/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.algo.bayesian.constraint.inference;

import edu.pitt.dbmi.algo.bayesian.constraint.inference.BCInference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;

public class BayesianConstraintInference {
    private static final String CAS_FLAG = "--cas";
    private static final int NUM_REQ_ARGS = 2;
    private static final String USAGE = "java -jar bci.jar --cas <cas-file>";
    private static File casFile;

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            System.err.println(USAGE);
            System.exit(127);
        }
        for (int i = 0; i < args.length; ++i) {
            String flag = args[i];
            if (flag.equals(CAS_FLAG)) {
                casFile = new File(args[++i]);
                BayesianConstraintInference.checkFile(casFile);
                continue;
            }
            System.out.printf("Unknown switch %s.\n", flag);
            System.exit(-1);
        }
        try {
            int[][] dataset = BayesianConstraintInference.readInDataset(casFile);
            int[] nodeDimension = BayesianConstraintInference.readInNodeDimension(casFile);
            BCInference bci = new BCInference(dataset, nodeDimension);
            BCInference.OP constraint = BCInference.OP.dependent;
            int x = 3;
            int y = 5;
            int[] z = new int[]{0};
            double pc = bci.probConstraint(constraint, x, y, z);
            System.out.printf("Probability constraint: %7.5f\n", pc);
            constraint = BCInference.OP.independent;
            x = 1;
            y = 4;
            z = new int[3];
            z[1] = 2;
            z[2] = 3;
            z[0] = 2;
            pc = bci.probConstraint(constraint, x, y, z);
            System.out.printf("Probability constraint: %7.5f\n", pc);
            constraint = BCInference.OP.independent;
            x = 1;
            y = 5;
            z = new int[2];
            z[1] = 3;
            z[0] = 1;
            pc = bci.probConstraint(constraint, x, y, z);
            System.out.printf("Probability constraint: %7.5f\n", pc);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] readInNodeDimension(File dataFile) throws IOException {
        int[] nodeDimension = null;
        Pattern spaceDelim = Pattern.compile("\\s+");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(dataFile));
            int numberOfNodes = Integer.parseInt(reader.readLine().trim());
            nodeDimension = new int[numberOfNodes + 2];
            String[] data = spaceDelim.split(reader.readLine().trim());
            int i = 0;
            for (String d : data) {
                nodeDimension[++i] = Integer.parseInt(d);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        return nodeDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[][] readInDataset(File dataFile) throws IOException {
        int[][] dataset = null;
        Pattern spaceDelim = Pattern.compile("\\s+");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(dataFile));
            int numberOfNodes = Integer.parseInt(reader.readLine().trim());
            reader.readLine();
            int numberOfCases = Integer.parseInt(reader.readLine().trim());
            dataset = new int[numberOfCases + 1][numberOfNodes + 2];
            for (int i = 1; i <= numberOfCases; ++i) {
                String[] data = spaceDelim.split(reader.readLine().trim());
                int j = 0;
                for (String d : data) {
                    dataset[i][++j] = Integer.parseInt(d);
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        return dataset;
    }

    private static void checkFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                System.err.printf("%s is not a file.", file.getName());
                System.exit(-1);
            }
        } else {
            System.err.printf("%s does not exist.", file.getName());
            System.exit(-1);
        }
    }
}

