/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader;

import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.metadata.ColumnMetadata;
import edu.pitt.dbmi.data.reader.metadata.InterventionalColumn;
import edu.pitt.dbmi.data.reader.metadata.Metadata;
import edu.pitt.dbmi.data.reader.tabular.TabularDataColumn;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class DataColumns {
    private DataColumns() {
    }

    public static DataColumn[] update(DataColumn[] dataColumns, Metadata metadata) {
        Map<String, ColumnMetadata> columnMetadataMap = DataColumns.getColumnMetadataMap(metadata);
        for (DataColumn dataColumn : dataColumns) {
            ColumnMetadata column = columnMetadataMap.get(dataColumn.getName());
            if (column == null) continue;
            dataColumn.setDiscrete(column.isDiscrete());
            column.setColumnNumber(dataColumn.getColumnNumber());
        }
        LinkedList<TabularDataColumn> additionalColumns = new LinkedList<TabularDataColumn>();
        int numOfCols = dataColumns.length;
        for (InterventionalColumn column : metadata.getInterventionalColumns()) {
            if (column.getStatusColumn() != null) continue;
            String name = column.getValueColumn().getName() + "_s";
            boolean bl = true;
            int columnNumber = ++numOfCols;
            column.setStatusColumn(new ColumnMetadata(name, columnNumber, true));
            additionalColumns.add(new TabularDataColumn(name, columnNumber, true, true));
        }
        if (!additionalColumns.isEmpty()) {
            DataColumn[] expandedDataColumns = new DataColumn[numOfCols];
            System.arraycopy(dataColumns, 0, expandedDataColumns, 0, dataColumns.length);
            int index = dataColumns.length;
            for (DataColumn dataColumn : additionalColumns) {
                expandedDataColumns[index++] = dataColumn;
            }
            dataColumns = expandedDataColumns;
        }
        return dataColumns;
    }

    private static Map<String, ColumnMetadata> getColumnMetadataMap(Metadata metadata) {
        HashMap<String, ColumnMetadata> columnMetadataMap = new HashMap<String, ColumnMetadata>();
        metadata.getDomainColumnns().forEach(column -> columnMetadataMap.put(column.getName(), (ColumnMetadata)column));
        metadata.getInterventionalColumns().forEach(column -> {
            ColumnMetadata col = column.getValueColumn();
            if (col != null) {
                columnMetadataMap.put(col.getName(), col);
            }
            if ((col = column.getStatusColumn()) != null) {
                columnMetadataMap.put(col.getName(), col);
            }
        });
        return columnMetadataMap;
    }
}

