/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.covariance;

import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.DataReaderException;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.covariance.CovarianceData;
import edu.pitt.dbmi.data.reader.covariance.CovarianceDataReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;

public class LowerCovarianceDataFileReader
extends DataFileReader
implements CovarianceDataReader {
    public LowerCovarianceDataFileReader(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public CovarianceData readInData() throws IOException {
        int numOfCases = this.getNumberOfCases();
        List<String> variables = this.getVariables();
        double[][] data = this.getCovarianceData(variables.size());
        return new LowerCovarianceData(numOfCases, variables, data);
    }

    private double[][] getCovarianceData(int matrixSize) throws IOException {
        double[][] data;
        block42: {
            data = new double[matrixSize][matrixSize];
            try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
                int len;
                boolean skip = false;
                boolean hasSeenNonblankChar = false;
                boolean hasQuoteChar = false;
                byte delimChar = this.delimiter.getByteValue();
                byte[] comment = this.commentMarker.getBytes();
                int cmntIndex = 0;
                boolean checkForComment = comment.length > 0;
                int lineDataNum = 1;
                int lineNum = 1;
                int colNum = 0;
                int col = 0;
                int row = 0;
                StringBuilder dataBuilder = new StringBuilder();
                byte prevChar = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                    for (int i = 0; i < len && !Thread.currentThread().isInterrupted(); ++i) {
                        byte currChar = buffer[i];
                        if (currChar == 13 || currChar == 10) {
                            if (currChar == 10 && prevChar == 13) {
                                prevChar = 10;
                                continue;
                            }
                            if (hasSeenNonblankChar && !skip) {
                                if (lineDataNum >= 3) {
                                    if (col > row) {
                                        String errMsg = String.format("Excess data on line %d.  Extracted %d value(s) but expected %d.", lineNum, col + 1, row + 1);
                                        throw new DataReaderException(errMsg);
                                    }
                                    if (col < row) {
                                        String errMsg = String.format("Insufficent data on line %d.  Extracted %d value(s) but expected %d.", lineNum, col + 1, row + 1);
                                        throw new DataReaderException(errMsg);
                                    }
                                    String value = dataBuilder.toString().trim();
                                    dataBuilder.delete(0, dataBuilder.length());
                                    ++colNum;
                                    if (value.isEmpty()) {
                                        String errMsg = String.format("Missing value on line %d at column %d.", lineNum, colNum);
                                        throw new DataReaderException(errMsg);
                                    }
                                    try {
                                        double covariance;
                                        data[row][col] = covariance = Double.parseDouble(value);
                                        data[col][row] = covariance;
                                    }
                                    catch (NumberFormatException exception) {
                                        String errMsg = String.format("Invalid number %s on line %d at column %d.", value, lineNum, colNum);
                                        throw new DataReaderException(errMsg);
                                    }
                                    ++row;
                                }
                                ++lineDataNum;
                            }
                            ++lineNum;
                            dataBuilder.delete(0, dataBuilder.length());
                            skip = false;
                            hasSeenNonblankChar = false;
                            cmntIndex = 0;
                            col = 0;
                            colNum = 0;
                            checkForComment = comment.length > 0;
                        } else if (!skip) {
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                            if (lineDataNum >= 3) {
                                if (currChar == this.quoteCharacter) {
                                    hasQuoteChar = !hasQuoteChar;
                                } else if (hasQuoteChar) {
                                    dataBuilder.append((char)currChar);
                                } else {
                                    boolean isDelimiter;
                                    if (this.delimiter == Delimiter.WHITESPACE) {
                                        isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                    } else {
                                        boolean bl = isDelimiter = currChar == delimChar;
                                    }
                                    if (isDelimiter) {
                                        if (col > row) {
                                            String errMsg = String.format("Excess data on line %d.  Extracted %d value(s) but expected %d.", lineNum, col + 1, row + 1);
                                            throw new DataReaderException(errMsg);
                                        }
                                        String value = dataBuilder.toString().trim();
                                        dataBuilder.delete(0, dataBuilder.length());
                                        ++colNum;
                                        if (value.isEmpty()) {
                                            String errMsg = String.format("Missing value on line %d at column %d.", lineNum, colNum);
                                            throw new DataReaderException(errMsg);
                                        }
                                        try {
                                            double covariance;
                                            data[row][col] = covariance = Double.parseDouble(value);
                                            data[col][row] = covariance;
                                        }
                                        catch (NumberFormatException exception) {
                                            String errMsg = String.format("Invalid number %s on line %d at column %d.", value, lineNum, colNum);
                                            throw new DataReaderException(errMsg);
                                        }
                                        ++col;
                                    } else {
                                        dataBuilder.append((char)currChar);
                                    }
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                }
                if (!hasSeenNonblankChar || skip || lineDataNum < 3) break block42;
                if (col > row) {
                    String errMsg = String.format("Excess data on line %d.  Extracted %d value(s) but expected %d.", lineNum, col + 1, row + 1);
                    throw new DataReaderException(errMsg);
                }
                if (col < row) {
                    String errMsg = String.format("Insufficent data on line %d.  Extracted %d value(s) but expected %d.", lineNum, col + 1, row + 1);
                    throw new DataReaderException(errMsg);
                }
                String value = dataBuilder.toString().trim();
                dataBuilder.delete(0, dataBuilder.length());
                ++colNum;
                if (value.isEmpty()) {
                    String errMsg = String.format("Missing value on line %d at column %d.", lineNum, colNum);
                    throw new DataReaderException(errMsg);
                }
                try {
                    double covariance;
                    data[row][col] = covariance = Double.parseDouble(value);
                    data[col][row] = covariance;
                }
                catch (NumberFormatException exception) {
                    String errMsg = String.format("Invalid number %s on line %d at column %d.", value, lineNum, colNum);
                    throw new DataReaderException(errMsg);
                }
            }
        }
        return data;
    }

    private List<String> getVariables() throws IOException {
        LinkedList<String> variables = new LinkedList<String>();
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            boolean finished = false;
            byte delimChar = this.delimiter.getByteValue();
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int lineDataNum = 1;
            int colNum = 0;
            int lineNum = 1;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        if (currChar == 10 && prevChar == 13) {
                            prevChar = 10;
                            continue;
                        }
                        if (hasSeenNonblankChar && !skip) {
                            if (lineDataNum == 2) {
                                String value = dataBuilder.toString().trim();
                                dataBuilder.delete(0, dataBuilder.length());
                                ++colNum;
                                if (value.isEmpty()) {
                                    String errMsg = String.format("Missing variable name on line %d at column %d.", lineNum, colNum);
                                    throw new DataReaderException(errMsg);
                                }
                                variables.add(value);
                            }
                            finished = ++lineDataNum > 2;
                        }
                        ++lineNum;
                        dataBuilder.delete(0, dataBuilder.length());
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        checkForComment = comment.length > 0;
                    } else if (!skip) {
                        if (currChar > DataFileReader.SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (lineDataNum == 2) {
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (hasQuoteChar) {
                                dataBuilder.append((char)currChar);
                            } else {
                                boolean isDelimiter;
                                if (this.delimiter == Delimiter.WHITESPACE) {
                                    isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                } else {
                                    boolean bl = isDelimiter = currChar == delimChar;
                                }
                                if (isDelimiter) {
                                    String value = dataBuilder.toString().trim();
                                    dataBuilder.delete(0, dataBuilder.length());
                                    ++colNum;
                                    if (value.isEmpty()) {
                                        String errMsg = String.format("Missing variable name on line %d at column %d.", lineNum, colNum);
                                        throw new DataReaderException(errMsg);
                                    }
                                    variables.add(value);
                                } else {
                                    dataBuilder.append((char)currChar);
                                }
                            }
                        }
                    }
                    prevChar = currChar;
                }
            }
            if (hasSeenNonblankChar && !skip && lineDataNum == 2) {
                String value = dataBuilder.toString().trim();
                dataBuilder.delete(0, dataBuilder.length());
                ++colNum;
                if (value.isEmpty()) {
                    String errMsg = String.format("Missing variable name on line %d at column %d.", lineNum, colNum);
                    throw new DataReaderException(errMsg);
                }
                variables.add(value);
            }
        }
        if (variables.isEmpty()) {
            String errMsg = "Covariance file does not contain variable names.";
            throw new DataReaderException("Covariance file does not contain variable names.");
        }
        return variables;
    }

    private int getNumberOfCases() throws IOException {
        String value;
        int numOfCases = 0;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean finished = false;
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int lineNum = 1;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        if (currChar == 10 && prevChar == 13) {
                            prevChar = 10;
                            continue;
                        }
                        boolean bl = finished = hasSeenNonblankChar && !skip;
                        if (!finished) {
                            ++lineNum;
                            dataBuilder.delete(0, dataBuilder.length());
                            skip = false;
                            hasSeenNonblankChar = false;
                            cmntIndex = 0;
                            checkForComment = comment.length > 0;
                        }
                    } else if (!skip) {
                        if (currChar > DataFileReader.SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (currChar != this.quoteCharacter) {
                            dataBuilder.append((char)currChar);
                        }
                    }
                    prevChar = currChar;
                }
            }
            value = dataBuilder.toString().trim();
            if (value.isEmpty()) {
                String errMsg = String.format("Line %d: Missing number of cases.", lineNum);
                throw new DataReaderException(errMsg);
            }
            try {
            }
            catch (NumberFormatException exception) {
                String errMsg = String.format("Invalid number %s on line %d.", value, lineNum);
                throw new DataReaderException(errMsg);
            }
        }
        return numOfCases += Integer.parseInt(value);
    }

    private static final class LowerCovarianceData
    implements CovarianceData {
        private final int numberOfCases;
        private final List<String> variables;
        private final double[][] data;

        private LowerCovarianceData(int numberOfCases, List<String> variables, double[][] data) {
            this.numberOfCases = numberOfCases;
            this.variables = variables;
            this.data = data;
        }

        @Override
        public int getNumberOfCases() {
            return this.numberOfCases;
        }

        @Override
        public List<String> getVariables() {
            return this.variables;
        }

        @Override
        public double[][] getData() {
            return this.data;
        }
    }
}

