/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.pitt.dbmi.data.reader.metadata.Metadata;
import edu.pitt.dbmi.data.reader.metadata.MetadataWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class MetadataFileWriter
implements MetadataWriter {
    @Override
    public String writeAsString(Metadata metadata) throws JsonProcessingException {
        return new ObjectMapper().writer().withDefaultPrettyPrinter().writeValueAsString(metadata);
    }

    @Override
    public void write(Metadata metadata, Path outputFile) throws IOException {
        ObjectWriter writer = new ObjectMapper().writer().withDefaultPrettyPrinter();
        if (Files.exists(outputFile, new LinkOption[0])) {
            if (Files.deleteIfExists(outputFile)) {
                Files.write(outputFile, writer.writeValueAsBytes(metadata), StandardOpenOption.CREATE);
            }
        } else {
            Files.write(outputFile, writer.writeValueAsBytes(metadata), StandardOpenOption.CREATE);
        }
    }
}

