/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.preview;

import edu.pitt.dbmi.data.reader.preview.AbstractDataPreviewer;
import edu.pitt.dbmi.data.reader.preview.DataPreviewer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BasicDataPreviewer
extends AbstractDataPreviewer
implements DataPreviewer {
    public BasicDataPreviewer(Path dataFile) {
        super(dataFile);
    }

    @Override
    public List<String> getPreviews(int fromLine, int toLine, int numOfCharacters) throws IOException {
        this.checkLineNumberParameter(fromLine, toLine);
        this.checkCharacterNumberParameter(numOfCharacters);
        if (toLine == 0 || numOfCharacters == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<String> linePreviews = new LinkedList<String>();
        try {
            this.getPreviews(fromLine, toLine, numOfCharacters, linePreviews);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            // empty catch block
        }
        return linePreviews;
    }

    protected void getPreviews(int fromLine, int toLine, int numOfCharacters, List<String> list) throws IOException {
        try (FileChannel fc = new RandomAccessFile(this.dataFile.toFile(), "r").getChannel();){
            long fileSize = fc.size();
            long position = 0L;
            long size = fileSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : fileSize;
            StringBuilder lineBuilder = new StringBuilder();
            boolean isDone = false;
            boolean skipLine = false;
            int lineNumber = 1;
            int charCount = 0;
            int previousChar = -1;
            do {
                MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, position, size);
                while (buffer.hasRemaining() && !isDone && !Thread.currentThread().isInterrupted()) {
                    byte currentChar = buffer.get();
                    if (skipLine) {
                        if (currentChar == 13 || currentChar == 10) {
                            skipLine = false;
                            if (charCount > 0) {
                                charCount = 0;
                                list.add(lineBuilder.toString());
                                lineBuilder.delete(0, lineBuilder.length());
                            }
                            ++lineNumber;
                            if (currentChar == 10 && previousChar == 13) {
                                --lineNumber;
                            }
                        }
                    } else if (lineNumber > toLine) {
                        isDone = true;
                    } else if (lineNumber < fromLine) {
                        skipLine = true;
                    } else if (currentChar == 13 || currentChar == 10) {
                        if (charCount > 0) {
                            charCount = 0;
                            list.add(lineBuilder.toString());
                            lineBuilder.delete(0, lineBuilder.length());
                        }
                        ++lineNumber;
                        if (currentChar == 10 && previousChar == 13) {
                            --lineNumber;
                        }
                    } else if (++charCount > numOfCharacters) {
                        lineBuilder.append("...");
                        skipLine = true;
                    } else {
                        lineBuilder.append((char)currentChar);
                    }
                    previousChar = currentChar;
                }
                if ((position += size) + size <= fileSize) continue;
                size = fileSize - position;
            } while (position < fileSize && !Thread.currentThread().isInterrupted());
        }
    }
}

