/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.Set;

public abstract class AbstractTabularColumnFileReader
extends DataFileReader {
    public AbstractTabularColumnFileReader(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    protected int[] toColumnNumbers(Set<String> columnNames) throws IOException {
        LinkedList<Integer> colNums = new LinkedList<Integer>();
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            boolean finished = false;
            byte delimChar = this.delimiter.getByteValue();
            byte prevChar = -1;
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int colNum = 0;
            StringBuilder dataBuilder = new StringBuilder();
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        boolean bl = finished = hasSeenNonblankChar && !skip;
                        if (finished) {
                            String value = dataBuilder.toString().trim();
                            dataBuilder.delete(0, dataBuilder.length());
                            ++colNum;
                            if (columnNames.contains(value)) {
                                colNums.add(colNum);
                            }
                        } else {
                            dataBuilder.delete(0, dataBuilder.length());
                        }
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        checkForComment = comment.length > 0;
                    } else if (!skip) {
                        if (currChar > DataFileReader.SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (currChar == this.quoteCharacter) {
                            hasQuoteChar = !hasQuoteChar;
                        } else if (hasQuoteChar) {
                            dataBuilder.append((char)currChar);
                        } else {
                            boolean isDelimiter;
                            if (this.delimiter == Delimiter.WHITESPACE) {
                                isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                            } else {
                                boolean bl = isDelimiter = currChar == delimChar;
                            }
                            if (isDelimiter) {
                                String value = dataBuilder.toString().trim();
                                dataBuilder.delete(0, dataBuilder.length());
                                ++colNum;
                                if (columnNames.contains(value)) {
                                    colNums.add(colNum);
                                }
                            } else {
                                dataBuilder.append((char)currChar);
                            }
                        }
                    }
                    prevChar = currChar;
                }
            }
            boolean bl = finished = hasSeenNonblankChar && !skip;
            if (finished) {
                String value = dataBuilder.toString().trim();
                dataBuilder.delete(0, dataBuilder.length());
                ++colNum;
                if (columnNames.contains(value)) {
                    colNums.add(colNum);
                }
            }
        }
        return colNums.stream().mapToInt(e -> e).toArray();
    }

    protected String stripCharacter(String word, byte character) {
        StringBuilder dataBuilder = new StringBuilder();
        for (byte currChar : word.getBytes()) {
            if (currChar == character) continue;
            dataBuilder.append((char)currChar);
        }
        return dataBuilder.toString();
    }
}

