/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DiscreteDataColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DiscreteTabularDataColumn
implements DiscreteDataColumn {
    private final DataColumn dataColumn;
    private final Map<String, Integer> values;
    private List<String> categories;

    public DiscreteTabularDataColumn(DataColumn dataColumn) {
        this.dataColumn = dataColumn;
        this.values = new TreeMap<String, Integer>();
    }

    public String toString() {
        return "DiscreteTabularDataColumn{dataColumn=" + this.dataColumn + ", values=" + this.values + ", categories=" + this.categories + '}';
    }

    @Override
    public Integer getEncodeValue(String value) {
        return this.values.get(value);
    }

    @Override
    public void recategorize() {
        Set<String> keyset = this.values.keySet();
        this.categories = new ArrayList<String>(keyset.size());
        int count = 0;
        for (String key : keyset) {
            this.values.put(key, count++);
            this.categories.add(key);
        }
    }

    @Override
    public void setValue(String value) {
        this.values.put(value, null);
    }

    @Override
    public DataColumn getDataColumn() {
        return this.dataColumn;
    }

    public Map<String, Integer> getValues() {
        return this.values;
    }

    @Override
    public List<String> getCategories() {
        return this.categories == null ? Collections.EMPTY_LIST : this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }
}

