/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DiscreteDataColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MixedTabularDataColumn
implements DiscreteDataColumn {
    private final DataColumn dataColumn;
    private final Map<String, Integer> values;
    private List<String> categories;

    public MixedTabularDataColumn(DataColumn dataColumn) {
        this.dataColumn = dataColumn;
        this.values = dataColumn.isDiscrete() ? new TreeMap() : null;
    }

    public String toString() {
        return "MixedTabularDataColumn{dataColumn=" + this.dataColumn + ", values=" + this.values + ", categories=" + this.categories + '}';
    }

    @Override
    public Integer getEncodeValue(String value) {
        return this.values == null ? -99 : this.values.get(value);
    }

    @Override
    public void recategorize() {
        if (this.values != null) {
            Set<String> keyset = this.values.keySet();
            this.categories = new ArrayList<String>(keyset.size());
            int count = 0;
            for (String key : keyset) {
                this.values.put(key, count++);
                this.categories.add(key);
            }
        }
    }

    @Override
    public void setValue(String value) {
        if (this.values != null) {
            this.values.put(value, null);
        }
    }

    @Override
    public DataColumn getDataColumn() {
        return this.dataColumn;
    }

    public Map<String, Integer> getValues() {
        return this.values;
    }

    @Override
    public List<String> getCategories() {
        return this.categories == null ? Collections.EMPTY_LIST : this.categories;
    }
}

