/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.DataReaderException;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.AbstractTabularColumnFileReader;
import edu.pitt.dbmi.data.reader.tabular.TabularColumnReader;
import edu.pitt.dbmi.data.reader.tabular.TabularDataColumn;
import edu.pitt.dbmi.data.reader.util.Columns;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public final class TabularColumnFileReader
extends AbstractTabularColumnFileReader
implements TabularColumnReader {
    public TabularColumnFileReader(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public DataColumn[] readInDataColumns(boolean isDiscrete) throws IOException {
        return this.readInDataColumns(Collections.EMPTY_SET, isDiscrete);
    }

    @Override
    public DataColumn[] readInDataColumns(Set<String> namesOfColumnsToExclude, boolean isDiscrete) throws IOException {
        if (namesOfColumnsToExclude == null || namesOfColumnsToExclude.isEmpty()) {
            return this.getColumns(new int[0], isDiscrete);
        }
        HashSet<String> cleanedColumnNames = new HashSet<String>();
        if (Character.isDefined(this.quoteCharacter)) {
            namesOfColumnsToExclude.stream().filter(Objects::nonNull).map(String::trim).filter(e -> !e.isEmpty()).map(e -> this.stripCharacter((String)e, this.quoteCharacter)).forEach(cleanedColumnNames::add);
        } else {
            namesOfColumnsToExclude.stream().filter(Objects::nonNull).map(String::trim).filter(e -> !e.isEmpty()).forEach(cleanedColumnNames::add);
        }
        int[] columnsToExclude = this.toColumnNumbers(cleanedColumnNames);
        return this.getColumns(columnsToExclude, isDiscrete);
    }

    @Override
    public DataColumn[] readInDataColumns(int[] columnsToExclude, boolean isDiscrete) throws IOException {
        int numOfCols = this.countNumberOfColumns();
        int[] sortedColsToExclude = Columns.sortNew(columnsToExclude);
        int[] validColsToExclude = Columns.extractValidColumnNumbers(numOfCols, sortedColsToExclude);
        return this.getColumns(validColsToExclude, isDiscrete);
    }

    @Override
    public DataColumn[] generateColumns(int[] columnsToExclude, boolean isDiscrete) throws IOException {
        LinkedList<TabularDataColumn> columns = new LinkedList<TabularDataColumn>();
        int[] sortedColsToExclude = Columns.sortNew(columnsToExclude);
        int numOfCols = this.countNumberOfColumns();
        String prefix = "C";
        int index = 0;
        for (int col = 1; col <= numOfCols && !Thread.currentThread().isInterrupted(); ++col) {
            if (index < sortedColsToExclude.length && col == sortedColsToExclude[index]) {
                ++index;
                continue;
            }
            columns.add(new TabularDataColumn("C" + col, col, false, isDiscrete));
        }
        return columns.toArray(new DataColumn[0]);
    }

    private DataColumn[] getColumns(int[] columnsToExclude, boolean isDiscrete) throws IOException {
        LinkedList<TabularDataColumn> columns = new LinkedList<TabularDataColumn>();
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            boolean finished = false;
            byte delimChar = this.delimiter.getByteValue();
            byte prevChar = -1;
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int numOfExCols = columnsToExclude.length;
            int exColsIndex = 0;
            int colNum = 0;
            int lineNum = 1;
            StringBuilder dataBuilder = new StringBuilder();
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        boolean bl = finished = hasSeenNonblankChar && !skip;
                        if (finished) {
                            String value = dataBuilder.toString().trim();
                            dataBuilder.delete(0, dataBuilder.length());
                            if (numOfExCols == 0 || exColsIndex >= numOfExCols || ++colNum != columnsToExclude[exColsIndex]) {
                                if (value.isEmpty()) {
                                    String errMsg = String.format("Missing variable name on line %d at column %d.", lineNum, colNum);
                                    throw new DataReaderException(errMsg);
                                }
                                columns.add(new TabularDataColumn(value, colNum, false, isDiscrete));
                            }
                        } else {
                            dataBuilder.delete(0, dataBuilder.length());
                        }
                        ++lineNum;
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        checkForComment = comment.length > 0;
                    } else if (!skip) {
                        if (currChar > DataFileReader.SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (currChar == this.quoteCharacter) {
                            hasQuoteChar = !hasQuoteChar;
                        } else if (hasQuoteChar) {
                            dataBuilder.append((char)currChar);
                        } else {
                            boolean isDelimiter;
                            if (this.delimiter == Delimiter.WHITESPACE) {
                                isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                            } else {
                                boolean bl = isDelimiter = currChar == delimChar;
                            }
                            if (isDelimiter) {
                                String value = dataBuilder.toString().trim();
                                dataBuilder.delete(0, dataBuilder.length());
                                if (numOfExCols > 0 && exColsIndex < numOfExCols && ++colNum == columnsToExclude[exColsIndex]) {
                                    ++exColsIndex;
                                } else {
                                    if (value.isEmpty()) {
                                        String errMsg = String.format("Missing variable name on line %d at column %d.", lineNum, colNum);
                                        throw new DataReaderException(errMsg);
                                    }
                                    columns.add(new TabularDataColumn(value, colNum, false, isDiscrete));
                                }
                            } else {
                                dataBuilder.append((char)currChar);
                            }
                        }
                    }
                    prevChar = currChar;
                }
            }
            boolean bl = finished = hasSeenNonblankChar && !skip;
            if (finished) {
                String value = dataBuilder.toString().trim();
                dataBuilder.delete(0, dataBuilder.length());
                if (numOfExCols == 0 || exColsIndex >= numOfExCols || ++colNum != columnsToExclude[exColsIndex]) {
                    if (value.isEmpty()) {
                        String errMsg = String.format("Missing variable name on line %d at column %d.", lineNum, colNum);
                        throw new DataReaderException(errMsg);
                    }
                    columns.add(new TabularDataColumn(value, colNum, false, isDiscrete));
                }
            }
        }
        return columns.toArray(new DataColumn[0]);
    }
}

