/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.ContinuousData;
import edu.pitt.dbmi.data.reader.Data;
import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.DataReaderException;
import edu.pitt.dbmi.data.reader.DatasetFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.DiscreteData;
import edu.pitt.dbmi.data.reader.DiscreteDataColumn;
import edu.pitt.dbmi.data.reader.metadata.ColumnMetadata;
import edu.pitt.dbmi.data.reader.metadata.Metadata;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularData;
import edu.pitt.dbmi.data.reader.tabular.DiscreteTabularDataColumn;
import edu.pitt.dbmi.data.reader.tabular.MixedTabularData;
import edu.pitt.dbmi.data.reader.tabular.MixedTabularDataColumn;
import edu.pitt.dbmi.data.reader.tabular.TabularDataReader;
import edu.pitt.dbmi.data.reader.tabular.VerticalDiscreteTabularData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class TabularDataFileReader
extends DatasetFileReader
implements TabularDataReader {
    public TabularDataFileReader(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public void determineDiscreteDataColumns(DataColumn[] dataColumns, int numberOfCategories, boolean hasHeader) throws IOException {
        int numOfColsInDataFile = 0;
        for (DataColumn dataColumn : dataColumns) {
            if (dataColumn.isGenerated()) continue;
            ++numOfColsInDataFile;
        }
        Set[] columnCategories = new Set[numOfColsInDataFile];
        for (int i = 0; i < numOfColsInDataFile; ++i) {
            columnCategories[i] = new HashSet();
        }
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skipHeader = hasHeader;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            byte delimChar = this.delimiter.getByteValue();
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int colNum = 0;
            int lineNum = 1;
            int columnIndex = 0;
            int maxCategoryToAdd = numberOfCategories + 1;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                int i;
                if (skipHeader) {
                    boolean finished = false;
                    for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                        byte currChar = buffer[i];
                        if (currChar == 13 || currChar == 10) {
                            if (currChar == 10 && prevChar == 13) {
                                prevChar = 10;
                                continue;
                            }
                            boolean bl = finished = hasSeenNonblankChar && !skip;
                            if (finished) {
                                skipHeader = false;
                            }
                            ++lineNum;
                            skip = false;
                            hasSeenNonblankChar = false;
                            cmntIndex = 0;
                            checkForComment = comment.length > 0;
                        } else if (!skip) {
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                }
                while (i < len && !Thread.currentThread().isInterrupted()) {
                    block46: {
                        byte currChar;
                        block47: {
                            block48: {
                                block49: {
                                    block44: {
                                        block45: {
                                            currChar = buffer[i];
                                            if (currChar != 13 && currChar != 10) break block44;
                                            if (currChar != 10 || prevChar != 13) break block45;
                                            prevChar = 10;
                                            break block46;
                                        }
                                        if (hasSeenNonblankChar && !skip) {
                                            DataColumn dataColumn = dataColumns[columnIndex];
                                            if (dataColumn.getColumnNumber() == ++colNum) {
                                                Set categories;
                                                String value = dataBuilder.toString().trim();
                                                if (!value.isEmpty() && !value.equals(this.missingDataMarker) && (categories = columnCategories[columnIndex]).size() < maxCategoryToAdd) {
                                                    categories.add(value);
                                                }
                                                ++columnIndex;
                                            }
                                            if (columnIndex < numOfColsInDataFile) {
                                                String errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                                                throw new DataReaderException(errMsg);
                                            }
                                        }
                                        ++lineNum;
                                        dataBuilder.delete(0, dataBuilder.length());
                                        skip = false;
                                        hasSeenNonblankChar = false;
                                        cmntIndex = 0;
                                        checkForComment = comment.length > 0;
                                        columnIndex = 0;
                                        colNum = 0;
                                        break block47;
                                    }
                                    if (skip) break block47;
                                    if (currChar > DataFileReader.SPACE_CHAR) {
                                        hasSeenNonblankChar = true;
                                    }
                                    if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block46;
                                    if (!checkForComment) break block48;
                                    if (currChar != comment[cmntIndex]) break block49;
                                    if (++cmntIndex != comment.length) break block48;
                                    skip = true;
                                    prevChar = currChar;
                                    break block46;
                                }
                                checkForComment = false;
                            }
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (hasQuoteChar) {
                                dataBuilder.append((char)currChar);
                            } else {
                                boolean isDelimiter;
                                if (this.delimiter == Delimiter.WHITESPACE) {
                                    isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                } else {
                                    boolean bl = isDelimiter = currChar == delimChar;
                                }
                                if (isDelimiter) {
                                    DataColumn dataColumn = dataColumns[columnIndex];
                                    if (dataColumn.getColumnNumber() == ++colNum) {
                                        Set categories;
                                        String value = dataBuilder.toString().trim();
                                        if (!value.isEmpty() && !value.equals(this.missingDataMarker) && (categories = columnCategories[columnIndex]).size() < maxCategoryToAdd) {
                                            categories.add(value);
                                        }
                                        if (++columnIndex == numOfColsInDataFile) {
                                            skip = true;
                                        }
                                    }
                                    dataBuilder.delete(0, dataBuilder.length());
                                } else {
                                    dataBuilder.append((char)currChar);
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                    ++i;
                }
            }
            if (!skipHeader && hasSeenNonblankChar && !skip) {
                DataColumn dataColumn = dataColumns[columnIndex];
                if (dataColumn.getColumnNumber() == ++colNum) {
                    Set categories;
                    String value = dataBuilder.toString().trim();
                    if (!value.isEmpty() && !value.equals(this.missingDataMarker) && (categories = columnCategories[columnIndex]).size() < maxCategoryToAdd) {
                        categories.add(value);
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfColsInDataFile) {
                    String errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                    throw new DataReaderException(errMsg);
                }
            }
        }
        for (int i = 0; i < numOfColsInDataFile; ++i) {
            dataColumns[i].setDiscrete(columnCategories[i].size() <= numberOfCategories);
        }
    }

    @Override
    public Data read(DataColumn[] dataColumns, boolean hasHeader) throws IOException {
        if (dataColumns == null) {
            return null;
        }
        int numOfColsInDataFile = 0;
        boolean isDiscrete = false;
        boolean isContinuous = false;
        for (DataColumn dataColumn : dataColumns) {
            if (dataColumn.isDiscrete()) {
                isDiscrete = true;
            } else {
                isContinuous = true;
            }
            if (dataColumn.isGenerated()) continue;
            ++numOfColsInDataFile;
        }
        if (isDiscrete && isContinuous) {
            return this.readInMixedData(dataColumns, hasHeader, numOfColsInDataFile);
        }
        if (isContinuous) {
            return this.readInContinuousData(dataColumns, hasHeader, numOfColsInDataFile);
        }
        if (isDiscrete) {
            return this.readInDiscreteData(dataColumns, hasHeader, numOfColsInDataFile);
        }
        return null;
    }

    @Override
    public Data read(DataColumn[] dataColumns, boolean hasHeader, Metadata metadata) throws IOException {
        Data data = this.read(dataColumns, hasHeader);
        if (metadata != null) {
            if (data instanceof ContinuousData) {
                ContinuousData continuousData = (ContinuousData)data;
                double[][] contData = continuousData.getData();
                metadata.getInterventionalColumns().forEach(column -> {
                    ColumnMetadata valCol = column.getValueColumn();
                    ColumnMetadata statCol = column.getStatusColumn();
                    int valColNum = valCol.getColumnNumber() - 1;
                    int statColNum = statCol.getColumnNumber() - 1;
                    double[] val = contData[valColNum];
                    double[] stat = contData[statColNum];
                    for (int i = 0; i < val.length; ++i) {
                        if (Double.isNaN(val[i])) {
                            val[i] = 0.0;
                            stat[i] = 0.0;
                            continue;
                        }
                        if (!dataColumns[statColNum].isGenerated()) continue;
                        stat[i] = 1.0;
                    }
                });
            } else if (data instanceof DiscreteData) {
                DiscreteData verticalDiscreteData = (DiscreteData)data;
                int[][] discreteData = verticalDiscreteData.getData();
                metadata.getInterventionalColumns().forEach(column -> {
                    ColumnMetadata valCol = column.getValueColumn();
                    ColumnMetadata statCol = column.getStatusColumn();
                    int valColNum = valCol.getColumnNumber() - 1;
                    int statColNum = statCol.getColumnNumber() - 1;
                    int[] val = discreteData[valColNum];
                    int[] stat = discreteData[statColNum];
                    for (int i = 0; i < val.length; ++i) {
                        if (val[i] == -99) {
                            val[i] = 0;
                            stat[i] = 0;
                            continue;
                        }
                        if (!dataColumns[statColNum].isGenerated()) continue;
                        stat[i] = 1;
                    }
                });
            } else if (data instanceof MixedTabularData) {
                MixedTabularData mixedTabularData = (MixedTabularData)data;
                double[][] continuousData = mixedTabularData.getContinuousData();
                int[][] discreteData = mixedTabularData.getDiscreteData();
                metadata.getInterventionalColumns().forEach(column -> {
                    ColumnMetadata valCol = column.getValueColumn();
                    ColumnMetadata statCol = column.getStatusColumn();
                    int valColNum = valCol.getColumnNumber() - 1;
                    int statColNum = statCol.getColumnNumber() - 1;
                    if (valCol.isDiscrete()) {
                        int[] val = discreteData[valColNum];
                        if (statCol.isDiscrete()) {
                            int[] stat = discreteData[statColNum];
                            for (int i = 0; i < val.length; ++i) {
                                if (val[i] == -99) {
                                    val[i] = 0;
                                    stat[i] = 0;
                                    continue;
                                }
                                if (!dataColumns[statColNum].isGenerated()) continue;
                                stat[i] = 1;
                            }
                        } else {
                            double[] stat = continuousData[statColNum];
                            for (int i = 0; i < val.length; ++i) {
                                if (val[i] == -99) {
                                    val[i] = 0;
                                    stat[i] = 0.0;
                                    continue;
                                }
                                if (!dataColumns[statColNum].isGenerated()) continue;
                                stat[i] = 1.0;
                            }
                        }
                    } else {
                        double[] val = continuousData[valColNum];
                        if (statCol.isDiscrete()) {
                            int[] stat = discreteData[statColNum];
                            for (int i = 0; i < val.length; ++i) {
                                if (Double.isNaN(val[i])) {
                                    val[i] = 0.0;
                                    stat[i] = 0;
                                    continue;
                                }
                                if (!dataColumns[statColNum].isGenerated()) continue;
                                stat[i] = 1;
                            }
                        } else {
                            double[] stat = continuousData[statColNum];
                            for (int i = 0; i < val.length; ++i) {
                                if (Double.isNaN(val[i])) {
                                    val[i] = 0.0;
                                    stat[i] = 0.0;
                                    continue;
                                }
                                if (!dataColumns[statColNum].isGenerated()) continue;
                                stat[i] = 1.0;
                            }
                        }
                    }
                });
            }
        }
        return data;
    }

    private Data readInMixedData(DataColumn[] dataColumns, boolean hasHeader, int numOfColsInDataFile) throws IOException {
        int numOfCols = dataColumns.length;
        int numOfRows = hasHeader ? this.countNumberOfLines() - 1 : this.countNumberOfLines();
        DiscreteDataColumn[] discreteDataColumns = new DiscreteDataColumn[numOfCols];
        double[][] continuousData = new double[numOfCols][];
        int[][] discreteData = new int[numOfCols][];
        for (int i = 0; i < numOfCols; ++i) {
            DataColumn dataColumn = dataColumns[i];
            if (dataColumn.isDiscrete()) {
                discreteData[i] = new int[numOfRows];
            } else {
                continuousData[i] = new double[numOfRows];
            }
            discreteDataColumns[i] = new MixedTabularDataColumn(dataColumn);
        }
        this.readInDiscreteCategorizes(discreteDataColumns, hasHeader, numOfColsInDataFile);
        this.readInMixedData(discreteDataColumns, hasHeader, continuousData, discreteData, numOfColsInDataFile);
        return new MixedTabularData(numOfRows, discreteDataColumns, continuousData, discreteData);
    }

    private void readInMixedData(DiscreteDataColumn[] dataColumns, boolean hasHeader, double[][] continuousData, int[][] discreteData, int numOfColsInDataFile) throws IOException {
        block54: {
            int numOfCols = dataColumns.length;
            try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
                String errMsg;
                int len;
                boolean skipHeader = hasHeader;
                boolean skip = false;
                boolean hasSeenNonblankChar = false;
                boolean hasQuoteChar = false;
                byte delimChar = this.delimiter.getByteValue();
                byte[] comment = this.commentMarker.getBytes();
                int cmntIndex = 0;
                boolean checkForComment = comment.length > 0;
                int colNum = 0;
                int lineNum = 1;
                int columnIndex = 0;
                int row = 0;
                int col = 0;
                StringBuilder dataBuilder = new StringBuilder();
                byte prevChar = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                    int i;
                    if (skipHeader) {
                        boolean finished = false;
                        for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                            byte currChar = buffer[i];
                            if (currChar == 13 || currChar == 10) {
                                if (currChar == 10 && prevChar == 13) {
                                    prevChar = 10;
                                    continue;
                                }
                                boolean bl = finished = hasSeenNonblankChar && !skip;
                                if (finished) {
                                    skipHeader = false;
                                }
                                ++lineNum;
                                skip = false;
                                hasSeenNonblankChar = false;
                                cmntIndex = 0;
                                checkForComment = comment.length > 0;
                            } else if (!skip) {
                                if (currChar > DataFileReader.SPACE_CHAR) {
                                    hasSeenNonblankChar = true;
                                }
                                if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                                if (checkForComment) {
                                    if (currChar == comment[cmntIndex]) {
                                        if (++cmntIndex == comment.length) {
                                            skip = true;
                                            prevChar = currChar;
                                            continue;
                                        }
                                    } else {
                                        checkForComment = false;
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                    }
                    while (i < len && !Thread.currentThread().isInterrupted()) {
                        block57: {
                            byte currChar;
                            block58: {
                                block59: {
                                    block60: {
                                        block55: {
                                            block56: {
                                                currChar = buffer[i];
                                                if (currChar != 13 && currChar != 10) break block55;
                                                if (currChar != 10 || prevChar != 13) break block56;
                                                prevChar = 10;
                                                break block57;
                                            }
                                            if (hasSeenNonblankChar && !skip) {
                                                DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                                                DataColumn dataColumn = discreteDataColumn.getDataColumn();
                                                if (dataColumn.getColumnNumber() == ++colNum) {
                                                    String value = dataBuilder.toString().trim();
                                                    if (dataColumn.isDiscrete()) {
                                                        discreteData[col++][row] = value.isEmpty() || value.equals(this.missingDataMarker) ? -99 : discreteDataColumn.getEncodeValue(value);
                                                    } else if (value.isEmpty() || value.equals(this.missingDataMarker)) {
                                                        continuousData[col++][row] = Double.NaN;
                                                    } else {
                                                        try {
                                                            continuousData[col++][row] = Double.parseDouble(value);
                                                        }
                                                        catch (NumberFormatException exception) {
                                                            String errMsg2 = String.format("Invalid number %s on line %d at column %d.", value, lineNum, colNum);
                                                            throw new DataReaderException(errMsg2);
                                                        }
                                                    }
                                                    ++columnIndex;
                                                }
                                                if (columnIndex < numOfColsInDataFile) {
                                                    errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                                                    throw new DataReaderException(errMsg);
                                                }
                                                ++row;
                                            }
                                            ++lineNum;
                                            dataBuilder.delete(0, dataBuilder.length());
                                            skip = false;
                                            hasSeenNonblankChar = false;
                                            cmntIndex = 0;
                                            checkForComment = comment.length > 0;
                                            columnIndex = 0;
                                            colNum = 0;
                                            col = 0;
                                            break block58;
                                        }
                                        if (skip) break block58;
                                        if (currChar > DataFileReader.SPACE_CHAR) {
                                            hasSeenNonblankChar = true;
                                        }
                                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block57;
                                        if (!checkForComment) break block59;
                                        if (currChar != comment[cmntIndex]) break block60;
                                        if (++cmntIndex != comment.length) break block59;
                                        skip = true;
                                        prevChar = currChar;
                                        break block57;
                                    }
                                    checkForComment = false;
                                }
                                if (currChar == this.quoteCharacter) {
                                    hasQuoteChar = !hasQuoteChar;
                                } else if (hasQuoteChar) {
                                    dataBuilder.append((char)currChar);
                                } else {
                                    boolean isDelimiter;
                                    if (this.delimiter == Delimiter.WHITESPACE) {
                                        isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                    } else {
                                        boolean bl = isDelimiter = currChar == delimChar;
                                    }
                                    if (isDelimiter) {
                                        DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                                        DataColumn dataColumn = discreteDataColumn.getDataColumn();
                                        if (dataColumn.getColumnNumber() == ++colNum) {
                                            String value = dataBuilder.toString().trim();
                                            if (dataColumn.isDiscrete()) {
                                                discreteData[col++][row] = value.isEmpty() || value.equals(this.missingDataMarker) ? -99 : discreteDataColumn.getEncodeValue(value);
                                            } else if (value.isEmpty() || value.equals(this.missingDataMarker)) {
                                                continuousData[col++][row] = Double.NaN;
                                            } else {
                                                try {
                                                    continuousData[col++][row] = Double.parseDouble(value);
                                                }
                                                catch (NumberFormatException exception) {
                                                    String errMsg3 = String.format("Invalid number %s on line %d at column %d.", value, lineNum, colNum);
                                                    throw new DataReaderException(errMsg3);
                                                }
                                            }
                                            if (++columnIndex == numOfCols) {
                                                ++row;
                                                skip = true;
                                            }
                                        }
                                        dataBuilder.delete(0, dataBuilder.length());
                                    } else {
                                        dataBuilder.append((char)currChar);
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                        ++i;
                    }
                }
                if (skipHeader || !hasSeenNonblankChar || skip) break block54;
                DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                DataColumn dataColumn = discreteDataColumn.getDataColumn();
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value = dataBuilder.toString().trim();
                    if (dataColumn.isDiscrete()) {
                        discreteData[col++][row] = value.isEmpty() || value.equals(this.missingDataMarker) ? -99 : discreteDataColumn.getEncodeValue(value);
                    } else if (value.isEmpty() || value.equals(this.missingDataMarker)) {
                        continuousData[col++][row] = Double.NaN;
                    } else {
                        try {
                            continuousData[col++][row] = Double.parseDouble(value);
                        }
                        catch (NumberFormatException exception) {
                            errMsg = String.format("Invalid number %s on line %d at column %d.", value, lineNum, colNum);
                            throw new DataReaderException(errMsg);
                        }
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfColsInDataFile) {
                    String errMsg4 = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                    throw new DataReaderException(errMsg4);
                }
            }
        }
    }

    private Data readInContinuousData(DataColumn[] dataColumns, boolean hasHeader, int numOfColsInDataFile) throws IOException {
        double[][] data;
        block48: {
            int numOfCols = dataColumns.length;
            int numOfRows = hasHeader ? this.countNumberOfLines() - 1 : this.countNumberOfLines();
            data = new double[numOfRows][numOfCols];
            try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
                String errMsg;
                int len;
                boolean skipHeader = hasHeader;
                boolean skip = false;
                boolean hasSeenNonblankChar = false;
                boolean hasQuoteChar = false;
                byte delimChar = this.delimiter.getByteValue();
                byte[] comment = this.commentMarker.getBytes();
                int cmntIndex = 0;
                boolean checkForComment = comment.length > 0;
                int colNum = 0;
                int lineNum = 1;
                int columnIndex = 0;
                int row = 0;
                int col = 0;
                StringBuilder dataBuilder = new StringBuilder();
                byte prevChar = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                    int i;
                    if (skipHeader) {
                        boolean finished = false;
                        for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                            byte currChar = buffer[i];
                            if (currChar == 13 || currChar == 10) {
                                if (currChar == 10 && prevChar == 13) {
                                    prevChar = 10;
                                    continue;
                                }
                                boolean bl = finished = hasSeenNonblankChar && !skip;
                                if (finished) {
                                    skipHeader = false;
                                }
                                ++lineNum;
                                skip = false;
                                hasSeenNonblankChar = false;
                                cmntIndex = 0;
                                checkForComment = comment.length > 0;
                            } else if (!skip) {
                                if (currChar > DataFileReader.SPACE_CHAR) {
                                    hasSeenNonblankChar = true;
                                }
                                if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                                if (checkForComment) {
                                    if (currChar == comment[cmntIndex]) {
                                        if (++cmntIndex == comment.length) {
                                            skip = true;
                                            prevChar = currChar;
                                            continue;
                                        }
                                    } else {
                                        checkForComment = false;
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                    }
                    while (i < len && !Thread.currentThread().isInterrupted()) {
                        block51: {
                            byte currChar;
                            block52: {
                                block53: {
                                    block54: {
                                        block49: {
                                            block50: {
                                                currChar = buffer[i];
                                                if (currChar != 13 && currChar != 10) break block49;
                                                if (currChar != 10 || prevChar != 13) break block50;
                                                prevChar = 10;
                                                break block51;
                                            }
                                            if (hasSeenNonblankChar && !skip) {
                                                DataColumn dataColumn = dataColumns[columnIndex];
                                                if (dataColumn.getColumnNumber() == ++colNum) {
                                                    String value = dataBuilder.toString().trim();
                                                    if (value.isEmpty() || value.equals(this.missingDataMarker)) {
                                                        data[row][col++] = Double.NaN;
                                                    } else {
                                                        try {
                                                            data[row][col++] = Double.parseDouble(value);
                                                        }
                                                        catch (NumberFormatException exception) {
                                                            String errMsg2 = String.format("Non-continuous number %s on line %d at column %d.", value, lineNum, colNum);
                                                            throw new DataReaderException(errMsg2);
                                                        }
                                                    }
                                                    ++columnIndex;
                                                }
                                                if (columnIndex < numOfColsInDataFile) {
                                                    errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                                                    throw new DataReaderException(errMsg);
                                                }
                                                ++row;
                                            }
                                            ++lineNum;
                                            dataBuilder.delete(0, dataBuilder.length());
                                            skip = false;
                                            hasSeenNonblankChar = false;
                                            cmntIndex = 0;
                                            checkForComment = comment.length > 0;
                                            columnIndex = 0;
                                            colNum = 0;
                                            col = 0;
                                            break block52;
                                        }
                                        if (skip) break block52;
                                        if (currChar > DataFileReader.SPACE_CHAR) {
                                            hasSeenNonblankChar = true;
                                        }
                                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block51;
                                        if (!checkForComment) break block53;
                                        if (currChar != comment[cmntIndex]) break block54;
                                        if (++cmntIndex != comment.length) break block53;
                                        skip = true;
                                        prevChar = currChar;
                                        break block51;
                                    }
                                    checkForComment = false;
                                }
                                if (currChar == this.quoteCharacter) {
                                    hasQuoteChar = !hasQuoteChar;
                                } else if (hasQuoteChar) {
                                    dataBuilder.append((char)currChar);
                                } else {
                                    boolean isDelimiter;
                                    if (this.delimiter == Delimiter.WHITESPACE) {
                                        isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                    } else {
                                        boolean bl = isDelimiter = currChar == delimChar;
                                    }
                                    if (isDelimiter) {
                                        DataColumn dataColumn = dataColumns[columnIndex];
                                        if (dataColumn.getColumnNumber() == ++colNum) {
                                            String value = dataBuilder.toString().trim();
                                            if (value.isEmpty() || value.equals(this.missingDataMarker)) {
                                                data[row][col++] = Double.NaN;
                                            } else {
                                                try {
                                                    data[row][col++] = Double.parseDouble(value);
                                                }
                                                catch (NumberFormatException exception) {
                                                    String errMsg3 = String.format("Non-continuous number %s on line %d at column %d.", value, lineNum, colNum);
                                                    throw new DataReaderException(errMsg3);
                                                }
                                            }
                                            if (++columnIndex == numOfCols) {
                                                ++row;
                                                skip = true;
                                            }
                                        }
                                        dataBuilder.delete(0, dataBuilder.length());
                                    } else {
                                        dataBuilder.append((char)currChar);
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                        ++i;
                    }
                }
                if (skipHeader || !hasSeenNonblankChar || skip) break block48;
                DataColumn dataColumn = dataColumns[columnIndex];
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value = dataBuilder.toString().trim();
                    if (value.isEmpty() || value.equals(this.missingDataMarker)) {
                        data[row][col++] = Double.NaN;
                    } else {
                        try {
                            data[row][col++] = Double.parseDouble(value);
                        }
                        catch (NumberFormatException exception) {
                            errMsg = String.format("Non-continuous number %s on line %d at column %d.", value, lineNum, colNum);
                            throw new DataReaderException(errMsg);
                        }
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfColsInDataFile) {
                    String errMsg4 = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                    throw new DataReaderException(errMsg4);
                }
            }
        }
        return new ContinuousTabularData(dataColumns, data);
    }

    private Data readInDiscreteData(DataColumn[] dataColumns, boolean hasHeader, int numOfColsInDataFile) throws IOException {
        DiscreteDataColumn[] discreteDataColumns = (DiscreteDataColumn[])Arrays.stream(dataColumns).map(DiscreteTabularDataColumn::new).toArray(DiscreteDataColumn[]::new);
        this.readInDiscreteCategorizes(discreteDataColumns, hasHeader, numOfColsInDataFile);
        int[][] data = this.readInDiscreteData(discreteDataColumns, hasHeader, numOfColsInDataFile);
        return new VerticalDiscreteTabularData(discreteDataColumns, data);
    }

    private int[][] readInDiscreteData(DiscreteDataColumn[] dataColumns, boolean hasHeader, int numOfColsInDataFile) throws IOException {
        int numOfCols = dataColumns.length;
        int numOfRows = hasHeader ? this.countNumberOfLines() - 1 : this.countNumberOfLines();
        int[][] data = new int[numOfCols][numOfRows];
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skipHeader = hasHeader;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            byte delimChar = this.delimiter.getByteValue();
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int colNum = 0;
            int lineNum = 1;
            int columnIndex = 0;
            int row = 0;
            int col = 0;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                int i;
                if (skipHeader) {
                    boolean finished = false;
                    for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                        byte currChar = buffer[i];
                        if (currChar == 13 || currChar == 10) {
                            if (currChar == 10 && prevChar == 13) {
                                prevChar = 10;
                                continue;
                            }
                            boolean bl = finished = hasSeenNonblankChar && !skip;
                            if (finished) {
                                skipHeader = false;
                            }
                            ++lineNum;
                            skip = false;
                            hasSeenNonblankChar = false;
                            cmntIndex = 0;
                            checkForComment = comment.length > 0;
                        } else if (!skip) {
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                }
                while (i < len && !Thread.currentThread().isInterrupted()) {
                    block40: {
                        byte currChar;
                        block41: {
                            block42: {
                                block43: {
                                    block38: {
                                        block39: {
                                            currChar = buffer[i];
                                            if (currChar != 13 && currChar != 10) break block38;
                                            if (currChar != 10 || prevChar != 13) break block39;
                                            prevChar = 10;
                                            break block40;
                                        }
                                        if (hasSeenNonblankChar && !skip) {
                                            DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                                            DataColumn dataColumn = discreteDataColumn.getDataColumn();
                                            if (dataColumn.getColumnNumber() == ++colNum) {
                                                String value = dataBuilder.toString().trim();
                                                data[col++][row] = value.isEmpty() || value.equals(this.missingDataMarker) ? -99 : discreteDataColumn.getEncodeValue(value);
                                                ++columnIndex;
                                            }
                                            if (columnIndex < numOfColsInDataFile) {
                                                String errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                                                throw new DataReaderException(errMsg);
                                            }
                                            ++row;
                                        }
                                        ++lineNum;
                                        dataBuilder.delete(0, dataBuilder.length());
                                        skip = false;
                                        hasSeenNonblankChar = false;
                                        cmntIndex = 0;
                                        checkForComment = comment.length > 0;
                                        columnIndex = 0;
                                        colNum = 0;
                                        col = 0;
                                        break block41;
                                    }
                                    if (skip) break block41;
                                    if (currChar > DataFileReader.SPACE_CHAR) {
                                        hasSeenNonblankChar = true;
                                    }
                                    if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block40;
                                    if (!checkForComment) break block42;
                                    if (currChar != comment[cmntIndex]) break block43;
                                    if (++cmntIndex != comment.length) break block42;
                                    skip = true;
                                    prevChar = currChar;
                                    break block40;
                                }
                                checkForComment = false;
                            }
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (hasQuoteChar) {
                                dataBuilder.append((char)currChar);
                            } else {
                                boolean isDelimiter;
                                if (this.delimiter == Delimiter.WHITESPACE) {
                                    isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                } else {
                                    boolean bl = isDelimiter = currChar == delimChar;
                                }
                                if (isDelimiter) {
                                    DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                                    DataColumn dataColumn = discreteDataColumn.getDataColumn();
                                    if (dataColumn.getColumnNumber() == ++colNum) {
                                        String value = dataBuilder.toString().trim();
                                        data[col++][row] = value.isEmpty() || value.equals(this.missingDataMarker) ? -99 : discreteDataColumn.getEncodeValue(value);
                                        if (++columnIndex == numOfCols) {
                                            ++row;
                                            skip = true;
                                        }
                                    }
                                    dataBuilder.delete(0, dataBuilder.length());
                                } else {
                                    dataBuilder.append((char)currChar);
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                    ++i;
                }
            }
            if (!skipHeader && hasSeenNonblankChar && !skip) {
                DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                DataColumn dataColumn = discreteDataColumn.getDataColumn();
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value = dataBuilder.toString().trim();
                    data[col++][row] = value.isEmpty() || value.equals(this.missingDataMarker) ? -99 : discreteDataColumn.getEncodeValue(value);
                    ++columnIndex;
                }
                if (columnIndex < numOfColsInDataFile) {
                    String errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                    throw new DataReaderException(errMsg);
                }
            }
        }
        return data;
    }

    private void readInDiscreteCategorizes(DiscreteDataColumn[] dataColumns, boolean hasHeader, int numOfColsInDataFile) throws IOException {
        int numOfCols = dataColumns.length;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skipHeader = hasHeader;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            byte delimChar = this.delimiter.getByteValue();
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int colNum = 0;
            int lineNum = 1;
            int columnIndex = 0;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                int i;
                if (skipHeader) {
                    boolean finished = false;
                    for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                        byte currChar = buffer[i];
                        if (currChar == 13 || currChar == 10) {
                            if (currChar == 10 && prevChar == 13) {
                                prevChar = 10;
                                continue;
                            }
                            boolean bl = finished = hasSeenNonblankChar && !skip;
                            if (finished) {
                                skipHeader = false;
                            }
                            ++lineNum;
                            skip = false;
                            hasSeenNonblankChar = false;
                            cmntIndex = 0;
                            checkForComment = comment.length > 0;
                        } else if (!skip) {
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                }
                while (i < len && !Thread.currentThread().isInterrupted()) {
                    block45: {
                        byte currChar;
                        block46: {
                            block47: {
                                block48: {
                                    block43: {
                                        block44: {
                                            currChar = buffer[i];
                                            if (currChar != 13 && currChar != 10) break block43;
                                            if (currChar != 10 || prevChar != 13) break block44;
                                            prevChar = 10;
                                            break block45;
                                        }
                                        if (hasSeenNonblankChar && !skip) {
                                            DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                                            DataColumn dataColumn = discreteDataColumn.getDataColumn();
                                            if (dataColumn.getColumnNumber() == ++colNum) {
                                                String value;
                                                if (dataColumn.isDiscrete() && (value = dataBuilder.toString().trim()).length() > 0 && !value.equals(this.missingDataMarker)) {
                                                    discreteDataColumn.setValue(value);
                                                }
                                                ++columnIndex;
                                            }
                                            if (columnIndex < numOfColsInDataFile) {
                                                String errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                                                throw new DataReaderException(errMsg);
                                            }
                                        }
                                        ++lineNum;
                                        dataBuilder.delete(0, dataBuilder.length());
                                        skip = false;
                                        hasSeenNonblankChar = false;
                                        cmntIndex = 0;
                                        checkForComment = comment.length > 0;
                                        columnIndex = 0;
                                        colNum = 0;
                                        break block46;
                                    }
                                    if (skip) break block46;
                                    if (currChar > DataFileReader.SPACE_CHAR) {
                                        hasSeenNonblankChar = true;
                                    }
                                    if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block45;
                                    if (!checkForComment) break block47;
                                    if (currChar != comment[cmntIndex]) break block48;
                                    if (++cmntIndex != comment.length) break block47;
                                    skip = true;
                                    prevChar = currChar;
                                    break block45;
                                }
                                checkForComment = false;
                            }
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (hasQuoteChar) {
                                dataBuilder.append((char)currChar);
                            } else {
                                boolean isDelimiter;
                                if (this.delimiter == Delimiter.WHITESPACE) {
                                    isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                } else {
                                    boolean bl = isDelimiter = currChar == delimChar;
                                }
                                if (isDelimiter) {
                                    DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                                    DataColumn dataColumn = discreteDataColumn.getDataColumn();
                                    if (dataColumn.getColumnNumber() == ++colNum) {
                                        String value;
                                        if (dataColumn.isDiscrete() && (value = dataBuilder.toString().trim()).length() > 0 && !value.equals(this.missingDataMarker)) {
                                            discreteDataColumn.setValue(value);
                                        }
                                        if (++columnIndex == numOfCols) {
                                            skip = true;
                                        }
                                    }
                                    dataBuilder.delete(0, dataBuilder.length());
                                } else {
                                    dataBuilder.append((char)currChar);
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                    ++i;
                }
            }
            if (!skipHeader && hasSeenNonblankChar && !skip) {
                DiscreteDataColumn discreteDataColumn = dataColumns[columnIndex];
                DataColumn dataColumn = discreteDataColumn.getDataColumn();
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value;
                    if (dataColumn.isDiscrete() && (value = dataBuilder.toString().trim()).length() > 0 && !value.equals(this.missingDataMarker)) {
                        discreteDataColumn.setValue(value);
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfColsInDataFile) {
                    String errMsg = String.format("Insufficient data on line %d.  Extracted %d value(s) but expected %d.", lineNum, columnIndex, numOfColsInDataFile);
                    throw new DataReaderException(errMsg);
                }
            }
        }
        for (DiscreteDataColumn discreteDataColumn : dataColumns) {
            if (discreteDataColumn.getDataColumn().isGenerated()) {
                discreteDataColumn.setValue("0");
                discreteDataColumn.setValue("1");
            }
            discreteDataColumn.recategorize();
        }
    }
}

