/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.Data;
import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DatasetFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.TabularColumnFileReader;
import edu.pitt.dbmi.data.reader.tabular.TabularDataFileReader;
import edu.pitt.dbmi.data.reader.tabular.VerticalDiscreteTabularDatasetReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;

public class VerticalDiscreteTabularDatasetFileReader
extends DatasetFileReader
implements VerticalDiscreteTabularDatasetReader {
    private boolean hasHeader = true;
    private char quoteChar = (char)34;

    public VerticalDiscreteTabularDatasetFileReader(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public Data readInData() throws IOException {
        return this.readInData(Collections.EMPTY_SET);
    }

    @Override
    public Data readInData(Set<String> namesOfColumnsToExclude) throws IOException {
        TabularColumnFileReader columnReader = new TabularColumnFileReader(this.dataFile, this.delimiter);
        columnReader.setCommentMarker(this.commentMarker);
        columnReader.setQuoteCharacter(this.quoteChar);
        boolean isDiscrete = true;
        DataColumn[] dataColumns = this.hasHeader ? columnReader.readInDataColumns(namesOfColumnsToExclude, true) : columnReader.generateColumns(new int[0], true);
        TabularDataFileReader dataReader = new TabularDataFileReader(this.dataFile, this.delimiter);
        dataReader.setCommentMarker(this.commentMarker);
        dataReader.setQuoteCharacter(this.quoteChar);
        dataReader.setMissingDataMarker(this.missingDataMarker);
        return dataReader.read(dataColumns, this.hasHeader);
    }

    @Override
    public Data readInData(int[] columnsToExclude) throws IOException {
        TabularColumnFileReader columnReader = new TabularColumnFileReader(this.dataFile, this.delimiter);
        columnReader.setCommentMarker(this.commentMarker);
        columnReader.setQuoteCharacter(this.quoteChar);
        boolean isDiscrete = true;
        DataColumn[] dataColumns = this.hasHeader ? columnReader.readInDataColumns(columnsToExclude, true) : columnReader.generateColumns(columnsToExclude, true);
        TabularDataFileReader dataReader = new TabularDataFileReader(this.dataFile, this.delimiter);
        dataReader.setCommentMarker(this.commentMarker);
        dataReader.setQuoteCharacter(this.quoteChar);
        dataReader.setMissingDataMarker(this.missingDataMarker);
        return dataReader.read(dataColumns, this.hasHeader);
    }

    @Override
    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    @Override
    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteChar = quoteCharacter;
    }
}

