/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class TextFileUtils {
    protected static final byte LINE_FEED = 10;
    protected static final byte CARRIAGE_RETURN = 13;
    protected static final byte SPACE_CHAR = 32;

    private TextFileUtils() {
    }

    public static char inferDelimiter(File file, int n, int skip, String comment, char quoteCharacter, char[] delims) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Parameter n must be positive integer.");
        }
        if (skip < 0) {
            throw new IllegalArgumentException("Parameter skip must be positive integer.");
        }
        comment = comment == null ? "" : comment.trim();
        int[] characters = new int[256];
        try (FileChannel fc = new RandomAccessFile(file, "r").getChannel();){
            long fileSize = fc.size();
            long position = 0L;
            long size = fileSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : fileSize;
            ByteBuffer byteBuffer = ByteBuffer.allocate(comment.length());
            byte[] prefix = comment.getBytes();
            int index = 0;
            boolean hasQuoteChar = false;
            boolean reqCheck = prefix.length > 0;
            boolean skipLine = false;
            int lineCount = 0;
            byte quoteChar = (byte)quoteCharacter;
            int prevNonBlankChar = 32;
            int prevChar = -1;
            do {
                MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, position, size);
                while (buffer.hasRemaining() && lineCount < n && !Thread.currentThread().isInterrupted()) {
                    byte currChar = buffer.get();
                    if (skipLine) {
                        if (currChar == 13 || currChar == 10) {
                            skipLine = false;
                        }
                    } else if (currChar == 13 || currChar == 10) {
                        ((Buffer)byteBuffer).clear();
                        boolean bl = reqCheck = prefix.length > 0;
                        if (currChar != 10 || prevChar != 13) {
                            ++lineCount;
                        }
                    } else {
                        if (currChar > 32) {
                            prevNonBlankChar = currChar;
                        }
                        if (reqCheck && prevNonBlankChar > 32) {
                            if (currChar == prefix[index]) {
                                if (++index == prefix.length) {
                                    index = 0;
                                    skipLine = true;
                                    prevNonBlankChar = 32;
                                    ((Buffer)byteBuffer).clear();
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                index = 0;
                                reqCheck = false;
                            }
                        }
                        if (reqCheck) {
                            byteBuffer.put(currChar);
                        } else if (skip > 0) {
                            --skip;
                            skipLine = true;
                            ((Buffer)byteBuffer).clear();
                        } else {
                            if (buffer.position() > 0) {
                                byteBuffer.flip();
                                while (byteBuffer.hasRemaining() && !Thread.currentThread().isInterrupted()) {
                                    byte c = byteBuffer.get();
                                    if (c == quoteChar) {
                                        hasQuoteChar = !hasQuoteChar;
                                        continue;
                                    }
                                    if (hasQuoteChar || c < 0 || c >= characters.length) continue;
                                    byte by = c;
                                    characters[by] = characters[by] + 1;
                                }
                                ((Buffer)byteBuffer).clear();
                            }
                            if (currChar == quoteChar) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (!hasQuoteChar && currChar >= 0 && currChar < characters.length) {
                                byte by = currChar;
                                characters[by] = characters[by] + 1;
                            }
                        }
                    }
                    prevChar = currChar;
                }
                if ((position += size) + size <= fileSize) continue;
                size = fileSize - position;
            } while (position < fileSize && lineCount < n && !Thread.currentThread().isInterrupted());
            int maxIndex = 0;
            for (int i = 1; i < delims.length && !Thread.currentThread().isInterrupted(); ++i) {
                if (characters[delims[maxIndex]] >= characters[delims[i]]) continue;
                maxIndex = i;
            }
            char c = delims[maxIndex];
            return c;
        }
    }
}

