/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.validation;

import edu.pitt.dbmi.data.reader.validation.MessageType;
import edu.pitt.dbmi.data.reader.validation.ValidationAttribute;
import edu.pitt.dbmi.data.reader.validation.ValidationCode;
import java.util.EnumMap;
import java.util.Map;

public class ValidationResult {
    private final ValidationCode code;
    private final MessageType messageType;
    private final Map<ValidationAttribute, Object> attributes;
    private String message;

    public ValidationResult(ValidationCode code, MessageType messageType) {
        this.code = code;
        this.messageType = messageType;
        this.attributes = new EnumMap<ValidationAttribute, Object>(ValidationAttribute.class);
    }

    public ValidationResult(ValidationCode code, MessageType messageType, String message) {
        this(code, messageType);
        this.message = message;
    }

    public String toString() {
        return "ValidationResult{code=" + (Object)((Object)this.code) + ", messageType=" + (Object)((Object)this.messageType) + ", attributes=" + this.attributes + ", message=" + this.message + '}';
    }

    public ValidationCode getCode() {
        return this.code;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Map<ValidationAttribute, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(ValidationAttribute attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

