/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.validation.covariance;

import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.validation.AbstractDataFileValidation;
import edu.pitt.dbmi.data.reader.validation.MessageType;
import edu.pitt.dbmi.data.reader.validation.ValidationAttribute;
import edu.pitt.dbmi.data.reader.validation.ValidationCode;
import edu.pitt.dbmi.data.reader.validation.ValidationResult;
import edu.pitt.dbmi.data.reader.validation.covariance.CovarianceValidation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;

public class LowerCovarianceDataFileValidation
extends AbstractDataFileValidation
implements CovarianceValidation {
    public LowerCovarianceDataFileValidation(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public List<ValidationResult> validate() {
        LinkedList<ValidationResult> validationResults;
        block3: {
            validationResults = new LinkedList<ValidationResult>();
            try {
                int numOfCases = this.validateNumberOfCases(validationResults);
                int numOfVars = this.validateVariables(validationResults);
                this.validateData(numOfVars, validationResults);
                if (validationResults.size() <= this.maxNumOfMsg) {
                    String infoMsg = String.format("There are %d cases and %d variables.", numOfCases, numOfVars);
                    ValidationResult result = new ValidationResult(ValidationCode.INFO, MessageType.FILE_SUMMARY, infoMsg);
                    result.setAttribute(ValidationAttribute.ROW_NUMBER, numOfCases);
                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, numOfVars);
                    validationResults.add(result);
                }
            }
            catch (IOException exception) {
                if (validationResults.size() > this.maxNumOfMsg) break block3;
                String errMsg = String.format("Unable to read file %s.", this.dataFile.getFileName());
                ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_IO_ERROR, errMsg);
                result.setAttribute(ValidationAttribute.FILE_NAME, this.dataFile.getFileName());
                validationResults.add(result);
            }
        }
        return validationResults;
    }

    /*
     * Unable to fully structure code
     */
    private void validateData(int numOfVars, List<ValidationResult> results) throws IOException {
        in = Files.newInputStream(this.dataFile, new OpenOption[]{StandardOpenOption.READ});
        try {
            skip = false;
            hasSeenNonblankChar = false;
            hasQuoteChar = false;
            delimChar = this.delimiter.getByteValue();
            comment = this.commentMarker.getBytes();
            cmntIndex = 0;
            checkForComment = comment.length > 0;
            lineDataNum = 1;
            lineNum = 1;
            colNum = 0;
            rowNum = 1;
            dataBuilder = new StringBuilder();
            prevChar = -1;
            buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && results.size() <= this.maxNumOfMsg && !Thread.currentThread().isInterrupted()) {
                for (i = 0; i < len && !Thread.currentThread().isInterrupted(); ++i) {
                    block55: {
                        block59: {
                            block58: {
                                currChar = buffer[i];
                                if (currChar != 13 && currChar != 10) break block58;
                                if (currChar == 10 && prevChar == 13) {
                                    prevChar = 10;
                                    continue;
                                }
                                if (hasSeenNonblankChar && !skip) {
                                    if (lineDataNum >= 3) {
                                        block54: {
                                            value = dataBuilder.toString().trim();
                                            if (++colNum > rowNum) {
                                                if (results.size() <= this.maxNumOfMsg) {
                                                    errMsg = String.format("Line %d: Excess data.  Expect %d value(s) but encounter %d.", new Object[]{lineNum, rowNum, colNum});
                                                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_EXCESS_DATA, errMsg);
                                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result.setAttribute(ValidationAttribute.EXPECTED_COUNT, rowNum);
                                                    result.setAttribute(ValidationAttribute.ACTUAL_COUNT, colNum);
                                                    results.add(result);
                                                }
                                            } else if (colNum < rowNum) {
                                                if (results.size() <= this.maxNumOfMsg) {
                                                    errMsg = String.format("Line %d: Insufficient data.  Expect %d value(s) but encounter %d.", new Object[]{lineNum, rowNum, colNum});
                                                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg);
                                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result.setAttribute(ValidationAttribute.EXPECTED_COUNT, rowNum);
                                                    result.setAttribute(ValidationAttribute.ACTUAL_COUNT, colNum);
                                                    results.add(result);
                                                }
                                            } else if (value.isEmpty()) {
                                                if (results.size() <= this.maxNumOfMsg) {
                                                    errMsg = String.format("Line %d, column %d: Missing value.", new Object[]{lineNum, colNum});
                                                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                                                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    results.add(result);
                                                }
                                            } else {
                                                try {
                                                    Double.parseDouble(value);
                                                }
                                                catch (NumberFormatException exception) {
                                                    if (results.size() > this.maxNumOfMsg) break block54;
                                                    errMsg = String.format("Line %d, column %d: Invalid number %s.", new Object[]{lineNum, colNum, value});
                                                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                                                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result.setAttribute(ValidationAttribute.VALUE, value);
                                                    results.add(result);
                                                }
                                            }
                                        }
                                        ++rowNum;
                                    }
                                    ++lineDataNum;
                                }
                                ++lineNum;
                                dataBuilder.delete(0, dataBuilder.length());
                                skip = false;
                                hasSeenNonblankChar = false;
                                cmntIndex = 0;
                                colNum = 0;
                                checkForComment = comment.length > 0;
                                break block55;
                            }
                            if (skip) break block55;
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                            if (lineDataNum < 3) break block55;
                            if (currChar != this.quoteCharacter) break block59;
                            hasQuoteChar = hasQuoteChar == false;
                            break block55;
                        }
                        if (hasQuoteChar) break block55;
                        if (this.delimiter == Delimiter.WHITESPACE) {
                            isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                        } else {
                            v0 = isDelimiter = currChar == delimChar;
                        }
                        if (!isDelimiter) ** GOTO lbl141
                        value = dataBuilder.toString().trim();
                        dataBuilder.delete(0, dataBuilder.length());
                        if (++colNum > rowNum) {
                            if (results.size() <= this.maxNumOfMsg) {
                                errMsg = String.format("Line %d: Excess data.  Expect %d value(s) but encounter %d.", new Object[]{lineNum, rowNum, colNum});
                                result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_EXCESS_DATA, errMsg);
                                result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                result.setAttribute(ValidationAttribute.EXPECTED_COUNT, rowNum);
                                result.setAttribute(ValidationAttribute.ACTUAL_COUNT, colNum);
                                results.add(result);
                            }
                        } else if (value.isEmpty()) {
                            if (results.size() <= this.maxNumOfMsg) {
                                errMsg = String.format("Line %d, column %d: Missing value.", new Object[]{lineNum, colNum});
                                result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                                result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                results.add(result);
                            }
                        } else {
                            try {
                                Double.parseDouble(value);
                            }
                            catch (NumberFormatException exception) {
                                if (results.size() <= this.maxNumOfMsg) {
                                    errMsg = String.format("Line %d, column %d: Invalid number %s.", new Object[]{lineNum, colNum, value});
                                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                    result.setAttribute(ValidationAttribute.VALUE, value);
                                    results.add(result);
                                }
                                break block55;
                            }
lbl141:
                            // 1 sources

                            dataBuilder.append((char)currChar);
                        }
                    }
                    prevChar = currChar;
                }
            }
            if (hasSeenNonblankChar && !skip && lineDataNum >= 3) {
                block56: {
                    value = dataBuilder.toString().trim();
                    if (++colNum > rowNum) {
                        if (results.size() <= this.maxNumOfMsg) {
                            errMsg = String.format("Line %d: Excess data.  Expect %d value(s) but encounter %d.", new Object[]{lineNum, rowNum, colNum});
                            result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_EXCESS_DATA, errMsg);
                            result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                            result.setAttribute(ValidationAttribute.EXPECTED_COUNT, rowNum);
                            result.setAttribute(ValidationAttribute.ACTUAL_COUNT, colNum);
                            results.add(result);
                        }
                    } else if (colNum < rowNum) {
                        if (results.size() <= this.maxNumOfMsg) {
                            errMsg = String.format("Line %d: Insufficient data.  Expect %d value(s) but encounter %d.", new Object[]{lineNum, rowNum, colNum});
                            result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg);
                            result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                            result.setAttribute(ValidationAttribute.EXPECTED_COUNT, rowNum);
                            result.setAttribute(ValidationAttribute.ACTUAL_COUNT, colNum);
                            results.add(result);
                        }
                    } else if (value.isEmpty()) {
                        if (results.size() <= this.maxNumOfMsg) {
                            errMsg = String.format("Line %d, column %d: Missing value.", new Object[]{lineNum, colNum});
                            result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                            result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                            result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                            results.add(result);
                        }
                    } else {
                        try {
                            Double.parseDouble(value);
                        }
                        catch (NumberFormatException exception) {
                            if (results.size() > this.maxNumOfMsg) break block56;
                            errMsg = String.format("Line %d, column %d: Invalid number %s.", new Object[]{lineNum, colNum, value});
                            result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                            result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                            result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                            result.setAttribute(ValidationAttribute.VALUE, value);
                            results.add(result);
                        }
                    }
                }
                ++rowNum;
            }
            if (--rowNum > numOfVars) {
                if (results.size() <= this.maxNumOfMsg) {
                    errMsg = String.format("Excess data.  Expect %d row(s) but encounter %d.", new Object[]{numOfVars, rowNum});
                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_EXCESS_DATA, errMsg);
                    result.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfVars);
                    result.setAttribute(ValidationAttribute.ACTUAL_COUNT, rowNum);
                    results.add(result);
                }
            } else if (rowNum < numOfVars && results.size() <= this.maxNumOfMsg) {
                errMsg = String.format("Insufficient data.  Expect %d row(s) but encounter %d.", new Object[]{numOfVars, rowNum});
                result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_EXCESS_DATA, errMsg);
                result.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfVars);
                result.setAttribute(ValidationAttribute.ACTUAL_COUNT, rowNum);
                results.add(result);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private int validateVariables(List<ValidationResult> results) throws IOException {
        int numOfVars = 0;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            boolean finished = false;
            byte delimChar = this.delimiter.getByteValue();
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int lineDataNum = 1;
            int colNum = 0;
            int lineNum = 1;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        if (currChar == 10 && prevChar == 13) {
                            prevChar = 10;
                            continue;
                        }
                        if (hasSeenNonblankChar && !skip) {
                            if (lineDataNum == 2) {
                                String value = dataBuilder.toString().trim();
                                ++colNum;
                                if (value.isEmpty() && results.size() <= this.maxNumOfMsg) {
                                    String errMsg = String.format("Line %d, column %d: Missing value.", lineNum, colNum);
                                    ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                    results.add(result);
                                }
                                ++numOfVars;
                                finished = true;
                            }
                            ++lineDataNum;
                        }
                        ++lineNum;
                        dataBuilder.delete(0, dataBuilder.length());
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        checkForComment = comment.length > 0;
                    } else if (!skip) {
                        if (currChar > DataFileReader.SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (lineDataNum == 2) {
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (!hasQuoteChar) {
                                boolean isDelimiter;
                                if (this.delimiter == Delimiter.WHITESPACE) {
                                    isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                } else {
                                    boolean bl = isDelimiter = currChar == delimChar;
                                }
                                if (isDelimiter) {
                                    String value = dataBuilder.toString().trim();
                                    dataBuilder.delete(0, dataBuilder.length());
                                    ++colNum;
                                    if (value.isEmpty() && results.size() <= this.maxNumOfMsg) {
                                        String errMsg = String.format("Line %d, column %d: Missing value.", lineNum, colNum);
                                        ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                                        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                        results.add(result);
                                    }
                                    ++numOfVars;
                                } else {
                                    dataBuilder.append((char)currChar);
                                }
                            }
                        }
                    }
                    prevChar = currChar;
                }
            }
            if (hasSeenNonblankChar && !skip && lineDataNum == 2) {
                String value = dataBuilder.toString().trim();
                dataBuilder.delete(0, dataBuilder.length());
                ++colNum;
                if (value.isEmpty() && results.size() <= this.maxNumOfMsg) {
                    String errMsg = String.format("Line %d, column %d: Missing value.", lineNum, colNum);
                    ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                    results.add(result);
                }
                ++numOfVars;
            }
        }
        if (numOfVars == 0 && results.size() <= this.maxNumOfMsg) {
            String errMsg = "Covariance file does not contain variable names.";
            ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, "Covariance file does not contain variable names.");
            results.add(result);
        }
        return numOfVars;
    }

    private int validateNumberOfCases(List<ValidationResult> results) throws IOException {
        int count;
        block26: {
            count = 0;
            try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
                int len;
                boolean skip = false;
                boolean hasSeenNonblankChar = false;
                boolean hasQuoteChar = false;
                boolean finished = false;
                byte[] comment = this.commentMarker.getBytes();
                int cmntIndex = 0;
                boolean checkForComment = comment.length > 0;
                int lineNum = 1;
                StringBuilder dataBuilder = new StringBuilder();
                byte prevChar = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                    for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                        byte currChar = buffer[i];
                        if (currChar == 13 || currChar == 10) {
                            if (currChar == 10 && prevChar == 13) {
                                prevChar = 10;
                                continue;
                            }
                            boolean bl = finished = hasSeenNonblankChar && !skip;
                            if (!finished) {
                                ++lineNum;
                                dataBuilder.delete(0, dataBuilder.length());
                                skip = false;
                                hasSeenNonblankChar = false;
                                cmntIndex = 0;
                                checkForComment = comment.length > 0;
                            }
                        } else if (!skip) {
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (!hasQuoteChar) {
                                dataBuilder.append((char)currChar);
                            }
                        }
                        prevChar = currChar;
                    }
                }
                String value = dataBuilder.toString().trim();
                if (value.isEmpty()) {
                    if (results.size() <= this.maxNumOfMsg) {
                        String errMsg = String.format("Line %d: Missing number of cases.", lineNum);
                        ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                        results.add(result);
                    }
                    break block26;
                }
                try {
                    count += Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    if (results.size() <= this.maxNumOfMsg) {
                        String errMsg = String.format("Line %d: Invalid number %s.", lineNum, value);
                        ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                        result.setAttribute(ValidationAttribute.VALUE, value);
                        results.add(result);
                    }
                }
            }
        }
        return count;
    }
}

