/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.validation.tabular;

import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.AbstractTabularColumnFileReader;
import edu.pitt.dbmi.data.reader.util.Columns;
import edu.pitt.dbmi.data.reader.validation.MessageType;
import edu.pitt.dbmi.data.reader.validation.ValidationAttribute;
import edu.pitt.dbmi.data.reader.validation.ValidationCode;
import edu.pitt.dbmi.data.reader.validation.ValidationResult;
import edu.pitt.dbmi.data.reader.validation.tabular.TabularColumnValidation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TabularColumnFileValidation
extends AbstractTabularColumnFileReader
implements TabularColumnValidation {
    private int maxNumOfMsg = Integer.MAX_VALUE;

    public TabularColumnFileValidation(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public List<ValidationResult> validate() {
        return this.validate(Collections.EMPTY_SET);
    }

    @Override
    public List<ValidationResult> validate(int[] excludedColumns) {
        LinkedList<ValidationResult> results;
        block2: {
            results = new LinkedList<ValidationResult>();
            try {
                int numOfCols = this.countNumberOfColumns();
                int[] excludedCols = Columns.sortNew(excludedColumns);
                int[] validCols = Columns.extractValidColumnNumbers(numOfCols, excludedCols);
                this.validateColumns(validCols, results);
            }
            catch (IOException exception) {
                if (results.size() > this.maxNumOfMsg) break block2;
                String errMsg = String.format("Unable to read file %s.", this.dataFile.getFileName());
                ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_IO_ERROR, errMsg);
                result.setAttribute(ValidationAttribute.FILE_NAME, this.dataFile.getFileName());
                results.add(result);
            }
        }
        return results;
    }

    @Override
    public List<ValidationResult> validate(Set<String> excludedColumns) {
        LinkedList<ValidationResult> results;
        block6: {
            results = new LinkedList<ValidationResult>();
            try {
                if (excludedColumns == null || excludedColumns.isEmpty()) {
                    this.validateColumns(new int[0], results);
                } else {
                    HashSet<String> modifiedExcludedCols = new HashSet<String>();
                    if (Character.isDefined(this.quoteCharacter)) {
                        excludedColumns.stream().map(e -> e.trim()).filter(e -> !e.isEmpty()).forEach(e -> modifiedExcludedCols.add(this.stripCharacter((String)e, this.quoteCharacter)));
                    } else {
                        excludedColumns.stream().map(e -> e.trim()).filter(e -> !e.isEmpty()).forEach(e -> modifiedExcludedCols.add((String)e));
                    }
                    int[] excludedCols = this.toColumnNumbers(modifiedExcludedCols);
                    this.validateColumns(excludedCols, results);
                }
            }
            catch (IOException exception) {
                if (results.size() > this.maxNumOfMsg) break block6;
                String errMsg = String.format("Unable to read file %s.", this.dataFile.getFileName());
                ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_IO_ERROR, errMsg);
                result.setAttribute(ValidationAttribute.FILE_NAME, this.dataFile.getFileName());
                results.add(result);
            }
        }
        return results;
    }

    private void validateColumns(int[] excludedColumns, List<ValidationResult> results) throws IOException {
        int numOfVars = 0;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            boolean finished = false;
            byte delimChar = this.delimiter.getByteValue();
            byte prevChar = -1;
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int numOfExCols = excludedColumns.length;
            int exColsIndex = 0;
            int colNum = 0;
            int lineNum = 1;
            StringBuilder dataBuilder = new StringBuilder();
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        boolean bl = finished = hasSeenNonblankChar && !skip;
                        if (finished) {
                            String value = dataBuilder.toString().trim();
                            dataBuilder.delete(0, dataBuilder.length());
                            if (numOfExCols == 0 || exColsIndex >= numOfExCols || ++colNum != excludedColumns[exColsIndex]) {
                                ++numOfVars;
                                if (value.isEmpty()) {
                                    String errMsg = String.format("Line %d, column %d: Missing variable name.", lineNum, colNum);
                                    ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                    results.add(result);
                                }
                            }
                        } else {
                            dataBuilder.delete(0, dataBuilder.length());
                        }
                        ++lineNum;
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        checkForComment = comment.length > 0;
                    } else if (!skip) {
                        if (currChar > DataFileReader.SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (currChar == this.quoteCharacter) {
                            hasQuoteChar = !hasQuoteChar;
                        } else if (hasQuoteChar) {
                            dataBuilder.append((char)currChar);
                        } else {
                            boolean isDelimiter;
                            if (this.delimiter == Delimiter.WHITESPACE) {
                                isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                            } else {
                                boolean bl = isDelimiter = currChar == delimChar;
                            }
                            if (isDelimiter) {
                                String value = dataBuilder.toString().trim();
                                dataBuilder.delete(0, dataBuilder.length());
                                if (numOfExCols > 0 && exColsIndex < numOfExCols && ++colNum == excludedColumns[exColsIndex]) {
                                    ++exColsIndex;
                                } else {
                                    ++numOfVars;
                                    if (value.isEmpty()) {
                                        String errMsg = String.format("Line %d, column %d: Missing variable name.", lineNum, colNum);
                                        ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                                        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                        results.add(result);
                                    }
                                }
                            } else {
                                dataBuilder.append((char)currChar);
                            }
                        }
                    }
                    prevChar = currChar;
                }
            }
            boolean bl = finished = hasSeenNonblankChar && !skip;
            if (finished) {
                String value = dataBuilder.toString().trim();
                dataBuilder.delete(0, dataBuilder.length());
                if (numOfExCols == 0 || exColsIndex >= numOfExCols || ++colNum != excludedColumns[exColsIndex]) {
                    ++numOfVars;
                    if (value.isEmpty()) {
                        String errMsg = String.format("Line %d, column %d: Missing variable name.", lineNum, colNum);
                        ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, errMsg);
                        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                        results.add(result);
                    }
                }
            }
        }
        if (numOfVars <= 0) {
            String errMsg = "No variable was read in.";
            ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_MISSING_VALUE, "No variable was read in.");
            results.add(result);
        }
        String infoMsg = String.format("There are %d variables.", numOfVars);
        ValidationResult result = new ValidationResult(ValidationCode.INFO, MessageType.FILE_SUMMARY, infoMsg);
        results.add(result);
    }

    @Override
    public void setMaximumNumberOfMessages(int maxNumOfMsg) {
        this.maxNumOfMsg = maxNumOfMsg;
    }
}

