/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.validation.tabular;

import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DataFileReader;
import edu.pitt.dbmi.data.reader.DatasetFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.validation.MessageType;
import edu.pitt.dbmi.data.reader.validation.ValidationAttribute;
import edu.pitt.dbmi.data.reader.validation.ValidationCode;
import edu.pitt.dbmi.data.reader.validation.ValidationResult;
import edu.pitt.dbmi.data.reader.validation.tabular.TabularDataValidation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;

public class TabularDataFileValidation
extends DatasetFileReader
implements TabularDataValidation {
    private int maxNumOfMsg = Integer.MAX_VALUE;

    public TabularDataFileValidation(Path dataFile, Delimiter delimiter) {
        super(dataFile, delimiter);
    }

    @Override
    public List<ValidationResult> validate(DataColumn[] dataColumns, boolean hasHeader) {
        LinkedList<ValidationResult> results;
        block10: {
            results = new LinkedList<ValidationResult>();
            boolean isDiscrete = false;
            boolean isContinuous = false;
            for (DataColumn dataColumn : dataColumns) {
                if (dataColumn.isDiscrete()) {
                    isDiscrete = true;
                } else {
                    isContinuous = true;
                }
                if (isDiscrete && isContinuous) break;
            }
            try {
                if (isDiscrete && isContinuous) {
                    this.validateMixedData(dataColumns, hasHeader, results);
                } else if (isContinuous) {
                    this.validateContinuousData(dataColumns, hasHeader, results);
                } else if (isDiscrete) {
                    this.validateDiscreteData(dataColumns, hasHeader, results);
                }
            }
            catch (IOException exception) {
                if (results.size() > this.maxNumOfMsg) break block10;
                String errMsg = String.format("Unable to read file %s.", this.dataFile.getFileName());
                ValidationResult result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_IO_ERROR, errMsg);
                result.setAttribute(ValidationAttribute.FILE_NAME, this.dataFile.getFileName());
                results.add(result);
            }
        }
        return results;
    }

    private void validateDiscreteData(DataColumn[] dataColumns, boolean hasHeader, List<ValidationResult> results) throws IOException {
        int numOfCols = dataColumns.length;
        int numOfRows = 0;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skipHeader = hasHeader;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            byte delimChar = this.delimiter.getByteValue();
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            int colNum = 0;
            int lineNum = 1;
            int columnIndex = 0;
            StringBuilder dataBuilder = new StringBuilder();
            byte prevChar = -1;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                int i;
                if (skipHeader) {
                    boolean finished = false;
                    for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                        byte currChar = buffer[i];
                        if (currChar == 13 || currChar == 10) {
                            if (currChar == 10 && prevChar == 13) {
                                prevChar = 10;
                                continue;
                            }
                            boolean bl = finished = hasSeenNonblankChar && !skip;
                            if (finished) {
                                skipHeader = false;
                            }
                            ++lineNum;
                            skip = false;
                            hasSeenNonblankChar = false;
                            cmntIndex = 0;
                            checkForComment = comment.length > 0;
                        } else if (!skip) {
                            if (currChar > DataFileReader.SPACE_CHAR) {
                                hasSeenNonblankChar = true;
                            }
                            if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                            if (checkForComment) {
                                if (currChar == comment[cmntIndex]) {
                                    if (++cmntIndex == comment.length) {
                                        skip = true;
                                        prevChar = currChar;
                                        continue;
                                    }
                                } else {
                                    checkForComment = false;
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                }
                while (i < len && !Thread.currentThread().isInterrupted()) {
                    block43: {
                        byte currChar;
                        block44: {
                            block45: {
                                block46: {
                                    block41: {
                                        block42: {
                                            currChar = buffer[i];
                                            if (currChar != 13 && currChar != 10) break block41;
                                            if (currChar != 10 || prevChar != 13) break block42;
                                            prevChar = 10;
                                            break block43;
                                        }
                                        if (hasSeenNonblankChar && !skip) {
                                            ValidationResult result;
                                            String errMsg;
                                            DataColumn dataColumn = dataColumns[columnIndex];
                                            if (dataColumn.getColumnNumber() == ++colNum) {
                                                String value = dataBuilder.toString().trim();
                                                if (value.isEmpty()) {
                                                    errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                                                    result = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                                                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    results.add(result);
                                                }
                                                ++columnIndex;
                                            }
                                            if (columnIndex < numOfCols) {
                                                int numOfValues = columnIndex + 1;
                                                errMsg = String.format("Line %d, column %d: Insufficient data.  Expect %d value(s) but encounter %d.", lineNum, colNum, numOfCols, numOfValues);
                                                result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg);
                                                result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                result.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfCols);
                                                result.setAttribute(ValidationAttribute.ACTUAL_COUNT, numOfValues);
                                                results.add(result);
                                            }
                                            ++numOfRows;
                                        }
                                        ++lineNum;
                                        dataBuilder.delete(0, dataBuilder.length());
                                        skip = false;
                                        hasSeenNonblankChar = false;
                                        cmntIndex = 0;
                                        checkForComment = comment.length > 0;
                                        columnIndex = 0;
                                        colNum = 0;
                                        break block44;
                                    }
                                    if (skip) break block44;
                                    if (currChar > DataFileReader.SPACE_CHAR) {
                                        hasSeenNonblankChar = true;
                                    }
                                    if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block43;
                                    if (!checkForComment) break block45;
                                    if (currChar != comment[cmntIndex]) break block46;
                                    if (++cmntIndex != comment.length) break block45;
                                    skip = true;
                                    prevChar = currChar;
                                    break block43;
                                }
                                checkForComment = false;
                            }
                            if (currChar == this.quoteCharacter) {
                                hasQuoteChar = !hasQuoteChar;
                            } else if (hasQuoteChar) {
                                dataBuilder.append((char)currChar);
                            } else {
                                boolean isDelimiter;
                                if (this.delimiter == Delimiter.WHITESPACE) {
                                    isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                } else {
                                    boolean bl = isDelimiter = currChar == delimChar;
                                }
                                if (isDelimiter) {
                                    DataColumn dataColumn = dataColumns[columnIndex];
                                    if (dataColumn.getColumnNumber() == ++colNum) {
                                        String value = dataBuilder.toString().trim();
                                        if (value.isEmpty()) {
                                            String errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                                            ValidationResult result = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                                            result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                            result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                            results.add(result);
                                        }
                                        if (++columnIndex == numOfCols) {
                                            skip = true;
                                            ++numOfRows;
                                        }
                                    }
                                    dataBuilder.delete(0, dataBuilder.length());
                                } else {
                                    dataBuilder.append((char)currChar);
                                }
                            }
                        }
                        prevChar = currChar;
                    }
                    ++i;
                }
            }
            if (!skipHeader && hasSeenNonblankChar && !skip) {
                ValidationResult result;
                DataColumn dataColumn = dataColumns[columnIndex];
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value = dataBuilder.toString().trim();
                    if (value.isEmpty()) {
                        String errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                        result = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                        results.add(result);
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfCols) {
                    int numOfValues = columnIndex + 1;
                    String errMsg = String.format("Line %d, column %d: Insufficient data.  Expect %d value(s) but encounter %d.", lineNum, colNum, numOfCols, numOfValues);
                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg);
                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                    result.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfCols);
                    result.setAttribute(ValidationAttribute.ACTUAL_COUNT, numOfValues);
                    results.add(result);
                }
                ++numOfRows;
            }
        }
        String infoMsg = String.format("There are %d cases and %d variables.", numOfRows, numOfCols);
        ValidationResult result = new ValidationResult(ValidationCode.INFO, MessageType.FILE_SUMMARY, infoMsg);
        result.setAttribute(ValidationAttribute.ROW_NUMBER, numOfRows);
        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, numOfCols);
        results.add(result);
    }

    private void validateContinuousData(DataColumn[] dataColumns, boolean hasHeader, List<ValidationResult> results) throws IOException {
        int numOfRows;
        int numOfCols;
        block51: {
            numOfCols = dataColumns.length;
            numOfRows = 0;
            try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
                ValidationResult result;
                int len;
                boolean skipHeader = hasHeader;
                boolean skip = false;
                boolean hasSeenNonblankChar = false;
                boolean hasQuoteChar = false;
                byte delimChar = this.delimiter.getByteValue();
                byte[] comment = this.commentMarker.getBytes();
                int cmntIndex = 0;
                boolean checkForComment = comment.length > 0;
                int colNum = 0;
                int lineNum = 1;
                int columnIndex = 0;
                StringBuilder dataBuilder = new StringBuilder();
                byte prevChar = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                    int i;
                    if (skipHeader) {
                        boolean finished = false;
                        for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                            byte currChar = buffer[i];
                            if (currChar == 13 || currChar == 10) {
                                if (currChar == 10 && prevChar == 13) {
                                    prevChar = 10;
                                    continue;
                                }
                                boolean bl = finished = hasSeenNonblankChar && !skip;
                                if (finished) {
                                    skipHeader = false;
                                }
                                ++lineNum;
                                skip = false;
                                hasSeenNonblankChar = false;
                                cmntIndex = 0;
                                checkForComment = comment.length > 0;
                            } else if (!skip) {
                                if (currChar > DataFileReader.SPACE_CHAR) {
                                    hasSeenNonblankChar = true;
                                }
                                if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                                if (checkForComment) {
                                    if (currChar == comment[cmntIndex]) {
                                        if (++cmntIndex == comment.length) {
                                            skip = true;
                                            prevChar = currChar;
                                            continue;
                                        }
                                    } else {
                                        checkForComment = false;
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                    }
                    while (i < len && !Thread.currentThread().isInterrupted()) {
                        block54: {
                            byte currChar;
                            block55: {
                                ValidationResult result2;
                                String errMsg;
                                block56: {
                                    block57: {
                                        block52: {
                                            block53: {
                                                currChar = buffer[i];
                                                if (currChar != 13 && currChar != 10) break block52;
                                                if (currChar != 10 || prevChar != 13) break block53;
                                                prevChar = 10;
                                                break block54;
                                            }
                                            if (hasSeenNonblankChar && !skip) {
                                                ValidationResult result3;
                                                String errMsg2;
                                                DataColumn dataColumn = dataColumns[columnIndex];
                                                if (dataColumn.getColumnNumber() == ++colNum) {
                                                    String value = dataBuilder.toString().trim();
                                                    if (value.isEmpty()) {
                                                        errMsg2 = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                                                        result3 = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg2);
                                                        result3.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                        result3.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                        results.add(result3);
                                                    } else if (!value.equals(this.missingDataMarker)) {
                                                        try {
                                                            Double.parseDouble(value);
                                                        }
                                                        catch (NumberFormatException exception) {
                                                            errMsg = String.format("Line %d, column %d: Non-continuous number %s.", lineNum, colNum, value);
                                                            result2 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                                                            result2.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                            result2.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                            result2.setAttribute(ValidationAttribute.VALUE, value);
                                                            results.add(result2);
                                                        }
                                                    }
                                                    ++columnIndex;
                                                }
                                                if (columnIndex < numOfCols) {
                                                    int numOfValues = columnIndex + 1;
                                                    errMsg2 = String.format("Line %d, column %d: Insufficient data.  Expect %d value(s) but encounter %d.", lineNum, colNum, numOfCols, numOfValues);
                                                    result3 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg2);
                                                    result3.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result3.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result3.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfCols);
                                                    result3.setAttribute(ValidationAttribute.ACTUAL_COUNT, numOfValues);
                                                    results.add(result3);
                                                }
                                                ++numOfRows;
                                            }
                                            ++lineNum;
                                            dataBuilder.delete(0, dataBuilder.length());
                                            skip = false;
                                            hasSeenNonblankChar = false;
                                            cmntIndex = 0;
                                            checkForComment = comment.length > 0;
                                            columnIndex = 0;
                                            colNum = 0;
                                            break block55;
                                        }
                                        if (skip) break block55;
                                        if (currChar > DataFileReader.SPACE_CHAR) {
                                            hasSeenNonblankChar = true;
                                        }
                                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block54;
                                        if (!checkForComment) break block56;
                                        if (currChar != comment[cmntIndex]) break block57;
                                        if (++cmntIndex != comment.length) break block56;
                                        skip = true;
                                        prevChar = currChar;
                                        break block54;
                                    }
                                    checkForComment = false;
                                }
                                if (currChar == this.quoteCharacter) {
                                    hasQuoteChar = !hasQuoteChar;
                                } else if (hasQuoteChar) {
                                    dataBuilder.append((char)currChar);
                                } else {
                                    boolean isDelimiter;
                                    if (this.delimiter == Delimiter.WHITESPACE) {
                                        isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                    } else {
                                        boolean bl = isDelimiter = currChar == delimChar;
                                    }
                                    if (isDelimiter) {
                                        DataColumn dataColumn = dataColumns[columnIndex];
                                        if (dataColumn.getColumnNumber() == ++colNum) {
                                            String value = dataBuilder.toString().trim();
                                            if (value.isEmpty()) {
                                                errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                                                result2 = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                                                result2.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                result2.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                results.add(result2);
                                            } else if (!value.equals(this.missingDataMarker)) {
                                                try {
                                                    Double.parseDouble(value);
                                                }
                                                catch (NumberFormatException exception) {
                                                    String errMsg3 = String.format("Line %d, column %d: Non-continuous number %s.", lineNum, colNum, value);
                                                    ValidationResult result4 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg3);
                                                    result4.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result4.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result4.setAttribute(ValidationAttribute.VALUE, value);
                                                    results.add(result4);
                                                }
                                            }
                                            if (++columnIndex == numOfCols) {
                                                skip = true;
                                                ++numOfRows;
                                            }
                                        }
                                        dataBuilder.delete(0, dataBuilder.length());
                                    } else {
                                        dataBuilder.append((char)currChar);
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                        ++i;
                    }
                }
                if (skipHeader || !hasSeenNonblankChar || skip) break block51;
                DataColumn dataColumn = dataColumns[columnIndex];
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value = dataBuilder.toString().trim();
                    if (value.isEmpty()) {
                        String errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                        result = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                        results.add(result);
                    } else if (!value.equals(this.missingDataMarker)) {
                        try {
                            Double.parseDouble(value);
                        }
                        catch (NumberFormatException exception) {
                            String errMsg = String.format("Line %d, column %d: Non-continuous number %s.", lineNum, colNum, value);
                            ValidationResult result5 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                            result5.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                            result5.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                            result5.setAttribute(ValidationAttribute.VALUE, value);
                            results.add(result5);
                        }
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfCols) {
                    int numOfValues = columnIndex + 1;
                    String errMsg = String.format("Line %d, column %d: Insufficient data.  Expect %d value(s) but encounter %d.", lineNum, colNum, numOfCols, numOfValues);
                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg);
                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                    result.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfCols);
                    result.setAttribute(ValidationAttribute.ACTUAL_COUNT, numOfValues);
                    results.add(result);
                }
                ++numOfRows;
            }
        }
        String infoMsg = String.format("There are %d cases and %d variables.", numOfRows, numOfCols);
        ValidationResult result = new ValidationResult(ValidationCode.INFO, MessageType.FILE_SUMMARY, infoMsg);
        result.setAttribute(ValidationAttribute.ROW_NUMBER, numOfRows);
        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, numOfCols);
        results.add(result);
    }

    private void validateMixedData(DataColumn[] dataColumns, boolean hasHeader, List<ValidationResult> results) throws IOException {
        int numOfRows;
        int numOfCols;
        block51: {
            numOfCols = dataColumns.length;
            numOfRows = 0;
            try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
                ValidationResult result;
                int len;
                boolean skipHeader = hasHeader;
                boolean skip = false;
                boolean hasSeenNonblankChar = false;
                boolean hasQuoteChar = false;
                byte delimChar = this.delimiter.getByteValue();
                byte[] comment = this.commentMarker.getBytes();
                int cmntIndex = 0;
                boolean checkForComment = comment.length > 0;
                int colNum = 0;
                int lineNum = 1;
                int columnIndex = 0;
                StringBuilder dataBuilder = new StringBuilder();
                byte prevChar = -1;
                byte[] buffer = new byte[0x100000];
                while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                    int i;
                    if (skipHeader) {
                        boolean finished = false;
                        for (i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                            byte currChar = buffer[i];
                            if (currChar == 13 || currChar == 10) {
                                if (currChar == 10 && prevChar == 13) {
                                    prevChar = 10;
                                    continue;
                                }
                                boolean bl = finished = hasSeenNonblankChar && !skip;
                                if (finished) {
                                    skipHeader = false;
                                }
                                ++lineNum;
                                skip = false;
                                hasSeenNonblankChar = false;
                                cmntIndex = 0;
                                checkForComment = comment.length > 0;
                            } else if (!skip) {
                                if (currChar > DataFileReader.SPACE_CHAR) {
                                    hasSeenNonblankChar = true;
                                }
                                if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) continue;
                                if (checkForComment) {
                                    if (currChar == comment[cmntIndex]) {
                                        if (++cmntIndex == comment.length) {
                                            skip = true;
                                            prevChar = currChar;
                                            continue;
                                        }
                                    } else {
                                        checkForComment = false;
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                    }
                    while (i < len && !Thread.currentThread().isInterrupted()) {
                        block54: {
                            byte currChar;
                            block55: {
                                ValidationResult result2;
                                String errMsg;
                                block56: {
                                    block57: {
                                        block52: {
                                            block53: {
                                                currChar = buffer[i];
                                                if (currChar != 13 && currChar != 10) break block52;
                                                if (currChar != 10 || prevChar != 13) break block53;
                                                prevChar = 10;
                                                break block54;
                                            }
                                            if (hasSeenNonblankChar && !skip) {
                                                ValidationResult result3;
                                                String errMsg2;
                                                DataColumn dataColumn = dataColumns[columnIndex];
                                                if (dataColumn.getColumnNumber() == ++colNum) {
                                                    String value = dataBuilder.toString().trim();
                                                    if (value.isEmpty()) {
                                                        errMsg2 = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                                                        result3 = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg2);
                                                        result3.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                        result3.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                        results.add(result3);
                                                    } else if (!value.equals(this.missingDataMarker) && !dataColumn.isDiscrete()) {
                                                        try {
                                                            Double.parseDouble(value);
                                                        }
                                                        catch (NumberFormatException exception) {
                                                            errMsg = String.format("Line %d, column %d: Non-continuous number %s.", lineNum, colNum, value);
                                                            result2 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                                                            result2.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                            result2.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                            result2.setAttribute(ValidationAttribute.VALUE, value);
                                                            results.add(result2);
                                                        }
                                                    }
                                                    ++columnIndex;
                                                }
                                                if (columnIndex < numOfCols) {
                                                    int numOfValues = columnIndex + 1;
                                                    errMsg2 = String.format("Line %d, column %d: Insufficient data.  Expect %d value(s) but encounter %d.", lineNum, colNum, numOfCols, numOfValues);
                                                    result3 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg2);
                                                    result3.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result3.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result3.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfCols);
                                                    result3.setAttribute(ValidationAttribute.ACTUAL_COUNT, numOfValues);
                                                    results.add(result3);
                                                }
                                                ++numOfRows;
                                            }
                                            ++lineNum;
                                            dataBuilder.delete(0, dataBuilder.length());
                                            skip = false;
                                            hasSeenNonblankChar = false;
                                            cmntIndex = 0;
                                            checkForComment = comment.length > 0;
                                            columnIndex = 0;
                                            colNum = 0;
                                            break block55;
                                        }
                                        if (skip) break block55;
                                        if (currChar > DataFileReader.SPACE_CHAR) {
                                            hasSeenNonblankChar = true;
                                        }
                                        if (currChar <= DataFileReader.SPACE_CHAR && !hasSeenNonblankChar) break block54;
                                        if (!checkForComment) break block56;
                                        if (currChar != comment[cmntIndex]) break block57;
                                        if (++cmntIndex != comment.length) break block56;
                                        skip = true;
                                        prevChar = currChar;
                                        break block54;
                                    }
                                    checkForComment = false;
                                }
                                if (currChar == this.quoteCharacter) {
                                    hasQuoteChar = !hasQuoteChar;
                                } else if (hasQuoteChar) {
                                    dataBuilder.append((char)currChar);
                                } else {
                                    boolean isDelimiter;
                                    if (this.delimiter == Delimiter.WHITESPACE) {
                                        isDelimiter = currChar <= DataFileReader.SPACE_CHAR && prevChar > DataFileReader.SPACE_CHAR;
                                    } else {
                                        boolean bl = isDelimiter = currChar == delimChar;
                                    }
                                    if (isDelimiter) {
                                        DataColumn dataColumn = dataColumns[columnIndex];
                                        if (dataColumn.getColumnNumber() == ++colNum) {
                                            String value = dataBuilder.toString().trim();
                                            if (value.isEmpty()) {
                                                errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                                                result2 = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                                                result2.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                result2.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                results.add(result2);
                                            } else if (!value.equals(this.missingDataMarker) && !dataColumn.isDiscrete()) {
                                                try {
                                                    Double.parseDouble(value);
                                                }
                                                catch (NumberFormatException exception) {
                                                    String errMsg3 = String.format("Line %d, column %d: Non-continuous number %s.", lineNum, colNum, value);
                                                    ValidationResult result4 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg3);
                                                    result4.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                                                    result4.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                                                    result4.setAttribute(ValidationAttribute.VALUE, value);
                                                    results.add(result4);
                                                }
                                            }
                                            if (++columnIndex == numOfCols) {
                                                skip = true;
                                                ++numOfRows;
                                            }
                                        }
                                        dataBuilder.delete(0, dataBuilder.length());
                                    } else {
                                        dataBuilder.append((char)currChar);
                                    }
                                }
                            }
                            prevChar = currChar;
                        }
                        ++i;
                    }
                }
                if (skipHeader || !hasSeenNonblankChar || skip) break block51;
                DataColumn dataColumn = dataColumns[columnIndex];
                if (dataColumn.getColumnNumber() == ++colNum) {
                    String value = dataBuilder.toString().trim();
                    if (value.isEmpty()) {
                        String errMsg = String.format("Line %d, column %d: Missing value.  No missing marker was found. Assumed value is missing.", lineNum, colNum);
                        result = new ValidationResult(ValidationCode.WARNING, MessageType.FILE_MISSING_VALUE, errMsg);
                        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                        result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                        results.add(result);
                    } else if (!value.equals(this.missingDataMarker) && !dataColumn.isDiscrete()) {
                        try {
                            Double.parseDouble(value);
                        }
                        catch (NumberFormatException exception) {
                            String errMsg = String.format("Line %d, column %d: Non-continuous number %s.", lineNum, colNum, value);
                            ValidationResult result5 = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INVALID_NUMBER, errMsg);
                            result5.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                            result5.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                            result5.setAttribute(ValidationAttribute.VALUE, value);
                            results.add(result5);
                        }
                    }
                    ++columnIndex;
                }
                if (columnIndex < numOfCols) {
                    int numOfValues = columnIndex + 1;
                    String errMsg = String.format("Line %d, column %d: Insufficient data.  Expect %d value(s) but encounter %d.", lineNum, colNum, numOfCols, numOfValues);
                    result = new ValidationResult(ValidationCode.ERROR, MessageType.FILE_INSUFFICIENT_DATA, errMsg);
                    result.setAttribute(ValidationAttribute.COLUMN_NUMBER, colNum);
                    result.setAttribute(ValidationAttribute.LINE_NUMBER, lineNum);
                    result.setAttribute(ValidationAttribute.EXPECTED_COUNT, numOfCols);
                    result.setAttribute(ValidationAttribute.ACTUAL_COUNT, numOfValues);
                    results.add(result);
                }
                ++numOfRows;
            }
        }
        String infoMsg = String.format("There are %d cases and %d variables.", numOfRows, numOfCols);
        ValidationResult result = new ValidationResult(ValidationCode.INFO, MessageType.FILE_SUMMARY, infoMsg);
        result.setAttribute(ValidationAttribute.ROW_NUMBER, numOfRows);
        result.setAttribute(ValidationAttribute.COLUMN_NUMBER, numOfCols);
        results.add(result);
    }

    @Override
    public void setMaximumNumberOfMessages(int maxNumOfMsg) {
        this.maxNumOfMsg = maxNumOfMsg;
    }
}

