/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.isp.sverchkov.data;

import edu.pitt.isp.sverchkov.data.DataTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataTableImpl<N, V>
implements DataTable<N, V> {
    private final List<N> variables;
    private final List<List<V>> rows;

    public DataTableImpl(List<? extends N> vars) {
        this.variables = Collections.unmodifiableList(new ArrayList<N>(vars));
        this.rows = new ArrayList<List<V>>();
    }

    @Override
    public List<N> variables() {
        return this.variables;
    }

    @Override
    public int columnCount() {
        return this.variables.size();
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public void addRow(List<? extends V> row) {
        int w;
        int m = row.size();
        if (m != (w = this.columnCount())) {
            throw new IllegalArgumentException("Tried to insert a row of length " + m + " into a table of width " + w + ".");
        }
        this.rows.add(Collections.unmodifiableList(new ArrayList<V>(row)));
    }

    @Override
    public Iterator<List<V>> iterator() {
        return Collections.unmodifiableList(this.rows).listIterator();
    }
}

