/*
 * Decompiled with CFR 0.152.
 */
package jgpml;

import Jama.Matrix;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CsvtoMatrix {
    public static Matrix[] load(String filename, int sizeofInputs, int sizeofOutputs) {
        boolean eof;
        ArrayList<double[]> inputsList = new ArrayList<double[]>();
        ArrayList<double[]> outputsList = new ArrayList<double[]>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("error: file " + filename + " not found.");
            e.printStackTrace();
        }
        int datasize = 0;
        do {
            eof = true;
            String readLine = null;
            try {
                readLine = br.readLine();
            }
            catch (IOException e) {
                System.out.println("error: reading from " + filename + ".");
                e.printStackTrace();
            }
            if (readLine != null && !readLine.equals("")) {
                eof = false;
                try {
                    int i;
                    double[] in = new double[sizeofInputs];
                    double[] out = new double[sizeofOutputs];
                    StringTokenizer st = new StringTokenizer(readLine, ", ");
                    int index = 0;
                    int currentVariable = 0;
                    for (i = 0; i < sizeofInputs; ++i) {
                        in[index] = Double.parseDouble(st.nextToken());
                        ++index;
                        ++currentVariable;
                    }
                    index = 0;
                    for (i = 0; i < sizeofOutputs; ++i) {
                        out[index] = Double.parseDouble(st.nextToken());
                        ++index;
                        ++currentVariable;
                    }
                    inputsList.add(in);
                    outputsList.add(out);
                }
                catch (Exception e) {
                    System.out.println(e + "\nerror: this line in the logfile does not agree with the configuration provided... it will be skipped");
                    --datasize;
                }
            }
            ++datasize;
        } while (!eof);
        double[][] inmat = new double[inputsList.size()][sizeofInputs];
        double[][] outmat = new double[inputsList.size()][sizeofOutputs];
        inputsList.toArray((T[])inmat);
        outputsList.toArray((T[])outmat);
        return new Matrix[]{new Matrix(inmat), new Matrix(outmat)};
    }

    public static void main(String[] args) {
        Matrix[] data = CsvtoMatrix.load("../machinelearning/src/machinelearning/gaussianprocess/armdata.csv", 6, 1);
    }
}

