/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import jgpml.covariancefunctions.CovarianceFunction;
import jgpml.covariancefunctions.MatrixOperations;

public class CovLINard
implements CovarianceFunction {
    private final int D;

    public CovLINard(int inputDimension) {
        this.D = inputDimension;
    }

    public static void main(String[] args) {
        CovLINard cf = new CovLINard(6);
        Matrix X = Matrix.identity(6, 6);
        Matrix logtheta = new Matrix(new double[][]{{0.1}, {0.2}, {0.3}, {0.4}, {0.5}, {0.6}});
        Matrix z = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0}});
        System.out.println();
        Matrix d = cf.computeDerivatives(logtheta, X, 5);
        d.print(d.getColumnDimension(), 8);
    }

    @Override
    public int numParameters() {
        return this.D;
    }

    @Override
    public Matrix compute(Matrix loghyper, Matrix X) {
        if (X.getColumnDimension() != this.D) {
            throw new IllegalArgumentException("The number of dimensions specified on the covariance function " + this.D + " must agree with the size of the input vector" + X.getColumnDimension());
        }
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        Matrix ell = MatrixOperations.exp(loghyper.getMatrix(0, this.D - 1, 0, 0));
        Matrix diag = new Matrix(this.D, this.D);
        for (int i = 0; i < this.D; ++i) {
            diag.set(i, i, 1.0 / ell.get(i, 0));
        }
        X = X.times(diag);
        return X.times(X.transpose());
    }

    @Override
    public Matrix[] compute(Matrix loghyper, Matrix X, Matrix Xstar) {
        if (X.getColumnDimension() != this.D) {
            throw new IllegalArgumentException("The number of dimensions specified on the covariance function " + this.D + " must agree with the size of the input vector" + X.getColumnDimension());
        }
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        Matrix ell = MatrixOperations.exp(loghyper.getMatrix(0, this.D - 1, 0, 0));
        Matrix diag = new Matrix(this.D, this.D);
        for (int i = 0; i < this.D; ++i) {
            diag.set(i, i, 1.0 / ell.get(i, 0));
        }
        X = X.times(diag);
        Xstar = Xstar.times(diag);
        Matrix A = MatrixOperations.sumRows(Xstar.arrayTimes(Xstar));
        Matrix B = X.times(Xstar.transpose());
        return new Matrix[]{A, B};
    }

    @Override
    public Matrix computeDerivatives(Matrix loghyper, Matrix X, int index) {
        if (X.getColumnDimension() != this.D) {
            throw new IllegalArgumentException("The number of dimensions specified on the covariance function " + this.D + " must agree with the size of the input vector" + X.getColumnDimension());
        }
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        if (index > this.numParameters() - 1) {
            throw new IllegalArgumentException("Wrong hyperparameters index " + index + " it should be smaller or equal to " + (this.numParameters() - 1));
        }
        Matrix ell = MatrixOperations.exp(loghyper.getMatrix(0, this.D - 1, 0, 0));
        Matrix diag = new Matrix(this.D, this.D);
        for (int i = 0; i < this.D; ++i) {
            diag.set(i, i, 1.0 / ell.get(i, 0));
        }
        X = X.times(diag);
        Matrix tmp = X.getMatrix(0, X.getRowDimension() - 1, index, index);
        return tmp.times(tmp.transpose()).times(-2.0);
    }
}

