/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import jgpml.covariancefunctions.CovarianceFunction;

public class CovSum
implements CovarianceFunction {
    CovarianceFunction[] f;
    int[] idx;

    public CovSum(int inputDimensions, CovarianceFunction ... f) {
        this.f = f;
        this.idx = new int[f.length + 1];
        for (int i = 0; i < f.length; ++i) {
            this.idx[i + 1] = this.idx[i] + f[i].numParameters();
        }
    }

    @Override
    public int numParameters() {
        return this.idx[this.f.length];
    }

    @Override
    public Matrix compute(Matrix loghyper, Matrix X) {
        Matrix K = new Matrix(X.getRowDimension(), X.getRowDimension());
        for (int i = 0; i < this.f.length; ++i) {
            Matrix loghyperi = loghyper.getMatrix(this.idx[i], this.idx[i + 1] - 1, 0, 0);
            K.plusEquals(this.f[i].compute(loghyperi, X));
        }
        return K;
    }

    @Override
    public Matrix[] compute(Matrix loghyper, Matrix X, Matrix Xstar) {
        Matrix A = new Matrix(Xstar.getRowDimension(), 1);
        Matrix B = new Matrix(X.getRowDimension(), Xstar.getRowDimension());
        for (int i = 0; i < this.f.length; ++i) {
            Matrix loghyperi = loghyper.getMatrix(this.idx[i], this.idx[i + 1] - 1, 0, 0);
            Matrix[] K = this.f[i].compute(loghyperi, X, Xstar);
            A.plusEquals(K[0]);
            B.plusEquals(K[1]);
        }
        return new Matrix[]{A, B};
    }

    @Override
    public Matrix computeDerivatives(Matrix loghyper, Matrix X, int index) {
        if (index > this.numParameters() - 1) {
            throw new IllegalArgumentException("Wrong hyperparameters index " + index + " it should be smaller or equal to " + (this.numParameters() - 1));
        }
        int whichf = 0;
        while (index > this.idx[whichf + 1] - 1) {
            ++whichf;
        }
        Matrix loghyperi = loghyper.getMatrix(this.idx[whichf], this.idx[whichf + 1] - 1, 0, 0);
        return this.f[whichf].computeDerivatives(loghyperi, X, index -= this.idx[whichf]);
    }
}

