function[M,loss] = SLIM(X,lamda1,lamda2,alpha,gamma)

%inputs
%X is the data-matrix to decompose
%lamda1 is l1 regularization weigth
%lamda2 is l2 regularization weigth
%alpha is the confidence in the zeros
%gamma is the penalization for the diagonal of M

%outputs
%M is the coefficient matrix
%loss contains the loss term after each iteration of the learning

[n,m] = size(X);
sqrteps = sqrt(eps);

M0 = 0.01*rand(n,n);

P = zeros(n,m) + alpha;
P(X>0) = 1;

I = eye(n);

loss = 0.5*norm(P.*(X-M0*X),'fro')^2 + 0.5*lamda2*norm(M0,'fro')^2 + lamda1*norm(M0,1);
i = 1;
delta = 1;
tic
while (delta>1e-3) 
    
    M = (M0.*(((P.^2).*X)*X'))./(((P.^2).*(M0*X))*X' + lamda2*M0 + lamda1*sign(M0)+ gamma*I + sqrteps);
    
    delta = max(max(abs(M - M0)))/(sqrteps + max(max(abs(M0))));

    M0 = M;
    
    i = i + 1;
    
    loss(i) = 0.5*norm(P.*(X-M0*X),'fro')^2 + 0.5*lamda2*norm(M0,'fro')^2 + lamda1*norm(M0,1);

end

end