# Requirements

```
accelerate=1.1.1
datasets=3.1.0
huggingface-hub=0.26.3
networkx=3.4.2
numpy=2.0.2
pandas=2.2.3
peft=0.6.3
python=3.10.15
scipy=1.14.1
torch=2.5.1
torchvision=0.20.1
tqdm=4.67.1
transformers=4.46.3
```

# Usage

First, you should `cd experiments/ViT` .

After that, to **reproduce** our all results, just use:

```
bash ViT_Base_all.bash
bash ViT_Large_all.bash
```

Or you can reproduce the results of a particular dataset individually.

For example, `ViT_Base` + `OxfordPets` :

```
#!/bin/bash
export WANDB_MODE=disabled
export NCCL_IB_DISABLE=1
export NCCL_P2P_DISABLE=1
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-base-patch16-224-in21k \
    --dataset-name pets \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 5e-3 \
    --bb_lr 5e-3 \
    --weight_decay 8e-4
```

# Acknowledge

This code is based on [FourierFT](https://github.com/Chaos96/fourierft), we thank for their efforts.