#!/bin/bash

export MODEL_NAME="stabilityai/stable-diffusion-xl-base-1.0"
export VAE_PATH="madebyollin/sdxl-vae-fp16-fix"

subjects=("xxx")

for subject in "${subjects[@]}"; do
  export INSTANCE_DIR=$subject
  
  echo "Starting training for subject: $subject"
  
  export OUTPUT_DIR=lora-trained-xl-mixer-$subject
  
  accelerate launch train_dreambooth_lora_sdxl.py \
    --pretrained_model_name_or_path=$MODEL_NAME  \
    --instance_data_dir=$INSTANCE_DIR \
    --pretrained_vae_model_name_or_path=$VAE_PATH \
    --output_dir=$OUTPUT_DIR \
    --mixed_precision="fp16" \
    --instance_prompt="a photo of $subject" \
    --resolution=1024 \
    --train_batch_size=1 \
    --gradient_accumulation_steps=4 \
    --learning_rate=1e-4 \
    --lr_scheduler="constant" \
    --lr_warmup_steps=0 \
    --max_train_steps=500 \
    --validation_prompt="A photo of $subject wearing a red hat" \
    --validation_epochs=40 \
    --seed="0" --lora_use_mixer 

  echo "Finished training for subject: $subject"
done

python3 infer.py