#!/bin/bash
export WANDB_MODE=disabled
export NCCL_IB_DISABLE=1
export NCCL_P2P_DISABLE=1


# pets
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name pets \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 5e-3 \
    --bb_lr 4e-3 \
    --weight_decay 8e-4



# cars
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name cars \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 9e-3 \
    --bb_lr 8e-3 \
    --weight_decay 4e-5


# cifar10
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name cifar10 \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 8e-3 \
    --bb_lr 4e-2 \
    --weight_decay 9e-5



# dtd
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name dtd \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 8e-3 \
    --bb_lr 9e-3 \
    --weight_decay 7e-5



# eurosat
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name eurosat \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 4e-3 \
    --bb_lr 8e-3 \
    --weight_decay 3e-4



# fgvc
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name fgvc \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 1.5e-2 \
    --bb_lr 1e-2 \
    --weight_decay 7e-5



# resisc45
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name resisc \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 7.5e-3 \
    --bb_lr 1.5e-2 \
    --weight_decay 3e-4




# cifar100
CUDA_VISIBLE_DEVICES=0 python exec.py \
    --model-name-or-path google/vit-large-patch16-224-in21k \
    --dataset-name cifar10 \
    --mode lora \
    --lora_use_act \
    --lora_r 2 \
    --lora_alpha 4 \
    --num_epochs 10 \
    --n_trial 1 \
    --head_lr 1.5e-2 \
    --bb_lr 5e-3 \
    --weight_decay 1e-4