import random


class Mem:
    def __init__(self, max_length=20):
        self.mem = []
        self.max_length = max_length

    def add(self, data):
        self.mem.append(data)
        if len(self.mem) > self.max_length:
            self.mem.pop(random.randint(0, self.max_length - 1))

    def get(self, num=1):
        if len(self.mem) < num:
            results = self.mem.copy()
        else:
            results = random.sample(self.mem, num).copy()
        return results
