import torch
import numpy as np


def exp_Gaussian_conditional_ll(
    Y: torch.Tensor, 
    sigmasq: float, 
    C: torch.Tensor, 
    tau: torch.Tensor, 
    d: torch.Tensor, 
    f_mu: torch.Tensor, # (D, N, R)
    f_var: torch.Tensor, 
):
    f_z_var = torch.square(tau.T[..., None]) * f_var + (torch.square(f_mu) + f_var) * tau.T[..., None] * (1 - tau.T[..., None])
    ll = -0.5 * (np.log(2 * np.pi) + np.log(sigmasq)) -1 / (2 * sigmasq) * torch.sum(
        torch.square(Y - torch.einsum("md,nd,dnr->nmr", C, tau, f_mu) + d[None]) + 
        torch.einsum("md,dnr->nmr", torch.square(C), f_z_var)
    )
    
    return ll
