This is a Pytorch implementation of the paper: A spectral perspective on GCNs.


## Requirements

  * Python 3.6.2
  * For the other packages, please refer to the requirements.txt.


## Usage

Demo easy-to-use scripts of different models for Cora are in `scripts` folder. You can reproduce the results by:
```
pip install -r requirements.txt
sh scripts/cora_MLP_160f.sh
```

 - cora_MLP_raw.sh runs a standard MLP.
 - cora_MLP_160f.sh runs a MLP with the first 160 low fequencies.
 - cora_GCN_raw.sh runs a standard GCN.
 - cora_GCN_with_100LF.sh runs a GCN whose adjacency matrix has been ablated of the first 100 low frequencies.


## Data
The data format is same as [GCN](https://github.com/tkipf/gcn). We provide only cora as an example (see `data` folder),
 but every other benchmark dataset can be download at  [Planetoid](https://github.com/kimiyoung/planetoid). 
The training setting strictly follows [FastGCN](https://github.com/matenure/FastGCN) and [ASGCN](https://github.com/huangwb/AS-GCN).