# coding=utf-8
# Copyright 2022 The Conceptual Learning Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Third shard of benchmark_generation_small_scale_generation_test."""

from unittest import mock

from absl.testing import absltest

from conceptual_learning.cscan import benchmark_generation_small_scale_generation_test_lib as bg_test_lib
from conceptual_learning.cscan import test_utils


class BenchmarkGenerationSmallScaleGenerationTest1(
    bg_test_lib.BenchmarkGenerationSmallScaleGenerationTest):

  @mock.patch.object(
      bg_test_lib.bg.dataset_generation.inference,
      'InferenceEngine',
      return_value=test_utils.make_fake_inference_engine())
  def test_dataset_specs_shows_no_issue_in_small_scale_generation(
      self, unused_mock):
    self._do_test_dataset_specs_shows_no_issue_in_small_scale_generation(2, 5)


if __name__ == '__main__':
  absltest.main()
