# coding=utf-8
# Copyright 2022 The Conceptual Learning Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import datetime

from absl.testing import absltest
import freezegun

from conceptual_learning.cscan import directory_names


class DirectoryNamesTest(absltest.TestCase):

  def test_get_default_benchmark_suite_directory_based_on_now(self):
    with freezegun.freeze_time('2021-06-15 17:21:58'):
      benchmark_suite_dir = (
          directory_names.get_default_benchmark_suite_directory(
              '/tmp/cscan', datetime.datetime.now()))
    self.assertEqual(benchmark_suite_dir,
                     '/tmp/cscan/2021-06-15-172158')

  def test_get_default_benchmark_suite_directory_based_on_a_past_time(self):
    with freezegun.freeze_time('2021-06-15 17:21:58'):
      benchmark_suite_dir = (
          directory_names.get_default_benchmark_suite_directory(
              '/tmp/cscan',
              datetime.datetime(2020, 5, 14, 16, 20, 57)))
    self.assertEqual(benchmark_suite_dir,
                     '/tmp/cscan/2020-05-14-162057')

  def test_get_default_benchmark_directory(self):
    benchmark_suite_dir = (
        directory_names.get_default_benchmark_directory(
            '/tmp/2020-05-14-162057', 'interpretation', 1))
    self.assertEqual(benchmark_suite_dir,
                     '/tmp/2020-05-14-162057/interpretation_1')


if __name__ == '__main__':
  absltest.main()
