# coding=utf-8
# Copyright 2022 The Conceptual Learning Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Library of I/O utilities used throughout the conceptual_learning project."""

import logging
import os

import tensorflow as tf


def back_up_existing_file(file_path):
  """Renames the file with a backup numeric suffix if it exists.

  Args:
    file_path: Fully-qualified path of the file to check.
  """
  if not tf.io.gfile.exists(file_path):
    return
  directory, file_name = os.path.split(file_path)
  base_file_name, extension = os.path.splitext(file_name)
  directory_content = tf.io.gfile.listdir(directory)
  backup_number = 1
  while True:
    backup_file_name = f'{base_file_name}_{backup_number}{extension}'
    if backup_file_name not in directory_content:
      break
    backup_number += 1
  backup_file_path = os.path.join(directory, backup_file_name)
  logging.info('Renaming file: %s -> %s', file_path, backup_file_path)
  tf.io.gfile.rename(file_path, backup_file_path)
