import os
import cv2
import numpy as np

from datasets import load_dataset
from src.data.eval_dataset.base_eval_dataset import AutoEvalPairDataset, add_metainfo_hook, RESOLUTION_MAPPING
from src.data.utils.vision_utils import process_video_frames, load_frames


# TODO: Move to a separpate config file
BREAKFAST_LABELS = ['pancake', 'cereal', 'sandwich', 'scrambledegg', 'friedegg', 'coffee', 'milk', 'tea', 'juice', 'salad']
K700_LABELS = ['waiting_in_line', 'fly_tying', 'breakdancing', 'coloring_in', 'counting_money', 'whistling', 'parkour', 'playing_keyboard', 'laying_tiles', 'flint_knapping', 'raising_eyebrows', 'base_jumping', 'playing_lute', 'brushing_floor', 'weaving_fabric', 'dining', 'dyeing_hair', 'archery', 'luge', 'sword_swallowing', 'clapping', 'arranging_flowers', 'sucking_lolly', 'writing', 'watering_plants', 'playing_piano', 'packing', 'lawn_mower_racing', 'yarn_spinning', 'carrying_baby', 'riding_mule', 'hugging_baby', 'tasting_food', 'massaging_back', 'cooking_scallops', 'planting_trees', 'playing_trombone', 'triple_jump', 'unloading_truck', 'climbing_a_rope', 'polishing_furniture', 'shearing_sheep', 'photobombing', 'stretching_leg', 'using_a_microscope', 'docking_boat', 'visiting_the_zoo', 'tiptoeing', 'headbutting', 'throwing_axe', 'needle_felting', 'mosh_pit_dancing', 'cooking_sausages_(not_on_barbeque)', 'tobogganing', 'making_a_sandwich', 'plastering', 'shaking_hands', 'playing_trumpet', 'assembling_bicycle', 'playing_road_hockey', 'playing_clarinet', 'applauding', 'cumbia', 'playing_pan_pipes', 'passing_American_football_(not_in_game)', 'cartwheeling', 'ironing', 'massaging_legs', 'ironing_hair', 'playing_saxophone', 'blowing_out_candles', 'wrestling', 'putting_on_shoes', 'ripping_paper', 'decorating_the_christmas_tree', 'sipping_cup', 'milking_goat', 'playing_mahjong', 'pull_ups', 'canoeing_or_kayaking', 'attending_conference', 'shouting', 'playing_marbles', 'playing_didgeridoo', 'brushing_hair', 'leatherworking', 'walking_on_stilts', 'saluting', 'twiddling_fingers', 'walking_through_snow', 'sticking_tongue_out', 'tango_dancing', 'playing_nose_flute', 'welding', 'stomping_grapes', 'kicking_field_goal', 'playing_polo', 'eating_watermelon', 'folding_napkins', 'coughing', 'assembling_computer', 'driving_car', 'bulldozing', 'blending_fruit', 'applying_cream', 'petting_cat', 'riding_scooter', 'winking', 'tasting_beer', 'high_jump', 'sign_language_interpreting', 'hugging_(not_baby)', 'playing_cricket', 'bouncing_on_bouncy_castle', 'cleaning_gutters', 'riding_or_walking_with_horse', 'being_in_zero_gravity', 'snowmobiling', 'playing_flute', 'gold_panning', 'belly_dancing', 'push_up', 'making_pizza', 'fixing_hair', 'preparing_salad', 'cutting_orange', 'pumping_fist', 'getting_a_tattoo', 'crawling_baby', 'dribbling_basketball', 'playing_american_football', 'playing_maracas', 'running_on_treadmill', 'springboard_diving', 'pushing_car', 'building_sandcastle', 'pouring_milk', 'square_dancing', 'hitting_baseball', 'sneezing', 'eating_chips', 'tackling', 'bench_pressing', 'doing_sudoku', 'windsurfing', 'throwing_snowballs', 'punching_person_(boxing)', 'rope_pushdown', 'capsizing', 'making_sushi', 'bowling', 'tagging_graffiti', 'folding_paper', 'parasailing', 'silent_disco', 'calculating', 'eating_spaghetti', 'singing', 'flipping_bottle', 'rock_scissors_paper', 'faceplanting', 'tasting_wine', 'laying_bricks', 'poking_bellybutton', 'chiseling_stone', 'skiing_crosscountry', 'playing_ocarina', 'lock_picking', 'crocheting', 'waxing_chest', 'building_lego', 'tying_knot_(not_on_a_tie)', 'unboxing', 'entering_church', 'filling_eyebrows', 'gospel_singing_in_church', 'playing_cymbals', 'breaking_boards', 'pole_vault', 'eating_hotdog', 'spelunking', 'throwing_discus', 'playing_billiards', 'hurdling', 'making_balloon_shapes', 'answering_questions', 'eating_cake', 'busking', 'bee_keeping', 'watching_tv', 'bookbinding', 'moving_baby', 'riding_unicycle', 'opening_wine_bottle', 'barbequing', 'blowing_glass', 'dancing_charleston', 'cleaning_toilet', 'card_throwing', 'opening_door', 'playing_ice_hockey', 'using_atm', 'filling_cake', 'dumpster_diving', 'pulling_espresso_shot', 'frying_vegetables', 'laughing', 'jetskiing', 'krumping', 'brushing_teeth', 'playing_beer_pong', 'making_jewelry', 'jumping_jacks', 'squeezing_orange', 'playing_blackjack', 'digging', 'playing_checkers', 'inflating_balloons', 'deadlifting', 'peeling_potatoes', 'walking_with_crutches', 'arm_wrestling', 'opening_refrigerator', 'slicing_onion', 'staring', 'arguing', 'playing_field_hockey', 'mountain_climber_(exercise)', 'roasting_marshmallows', 'cheerleading', 'delivering_mail', 'throwing_water_balloon', 'shining_shoes', 'putting_on_sari', 'weaving_basket', 'rolling_pastry', 'threading_needle', 'drop_kicking', 'side_kick', 'presenting_weather_forecast', 'playing_slot_machine', 'kissing', 'decoupage', 'shuffling_feet', 'making_slime', 'playing_darts', 'ice_fishing', 'person_collecting_garbage', 'scuba_diving', 'making_paper_aeroplanes', 'celebrating', 'riding_snow_blower', 'directing_traffic', 'massaging_feet', 'somersaulting', 'snowboarding', 'golf_chipping', 'cracking_knuckles', 'feeding_fish', 'dodgeball', 'squat', 'grooming_dog', 'putting_in_contact_lenses', 'playing_paintball', 'skydiving', 'javelin_throw', 'treating_wood', 'playing_shuffleboard', 'setting_table', 'situp', 'playing_recorder', 'cleaning_windows', 'vacuuming_car', 'playing_volleyball', 'hula_hooping', 'smoking_hookah', 'catching_or_throwing_baseball', 'repairing_puncture', 'shot_put', 'dancing_macarena', 'holding_snake', 'throwing_knife', 'biking_through_snow', 'using_inhaler', 'sled_dog_racing', 'playing_gong', 'tying_necktie', 'making_the_bed', 'pouring_wine', 'high_fiving', 'doing_nails', 'ice_skating', 'rock_climbing', 'snowkiting', 'getting_a_piercing', 'making_tea', 'longboarding', 'blasting_sand', 'wood_burning_(art)', 'massaging_neck', 'swimming_breast_stroke', 'smoking_pipe', 'bending_back', 'eating_nachos', 'flying_kite', 'surfing_crowd', 'tying_bow_tie', 'chopping_wood', 'changing_gear_in_car', 'tie_dying', 'cutting_watermelon', 'pretending_to_be_a_statue', 'playing_organ', 'sweeping_floor', 'playing_netball', 'juggling_balls', 'washing_hands', 'installing_carpet', 'knitting', 'carrying_weight', 'waxing_armpits', 'breaking_glass', 'battle_rope_training', 'trapezing', 'swimming_with_sharks', "massaging_person's_head", 'shredding_paper', 'cooking_on_campfire', 'playing_harmonica', 'mowing_lawn', 'golf_putting', 'washing_feet', 'swimming_front_crawl', 'washing_hair', 'playing_cards', 'dealing_cards', 'slacklining', 'wading_through_water', 'eating_carrots', 'lighting_fire', 'changing_oil', 'backflip_(human)', 'cleaning_shoes', 'pushing_cart', 'long_jump', 'rolling_eyes', 'eating_ice_cream', 'trimming_shrubs', 'pouring_beer', 'building_shed', 'texting', 'playing_with_trains', 'skipping_stone', 'training_dog', 'hurling_(sport)', 'braiding_hair', 'laying_decking', 'using_remote_controller_(not_gaming)', 'closing_door', 'surveying', 'adjusting_glasses', 'headbanging', 'playing_bass_guitar', 'swimming_butterfly_stroke', 'auctioning', 'separating_eggs', 'tap_dancing', 'geocaching', 'passing_American_football_(in_game)', 'doing_jigsaw_puzzle', 'playing_harp', 'playing_oboe', 'jaywalking', 'chiseling_wood', 'drawing', 'pushing_wheelchair', 'snatch_weight_lifting', 'calligraphy', 'extinguishing_fire', 'pinching', 'metal_detecting', 'lunge', 'shoot_dance', 'bobsledding', 'arresting', 'carving_pumpkin', 'reading_newspaper', 'laying_concrete', 'fidgeting', 'mushroom_foraging', 'cutting_apple', 'yawning', 'crossing_river', 'shaving_head', 'stacking_dice', 'playing_squash_or_racquetball', 'blowing_leaves', 'folding_clothes', 'shooting_basketball', 'hoverboarding', 'spinning_poi', 'bending_metal', 'making_horseshoes', 'playing_bagpipes', 'eating_doughnuts', 'fixing_bicycle', 'punching_bag', 'playing_rubiks_cube', 'spinning_plates', 'playing_xylophone', 'waving_hand', 'playing_hand_clapping_games', 'laying_stone', 'putting_wallpaper_on_wall', 'skateboarding', 'scrambling_eggs', 'pumping_gas', 'hopscotch', 'bodysurfing', 'jumpstyle_dancing', 'paragliding', 'playing_kickball', 'sanding_wood', 'taking_photo', 'using_a_sledge_hammer', 'eating_burger', 'disc_golfing', 'sausage_making', 'playing_guitar', 'motorcycling', 'talking_on_cell_phone', 'riding_elephant', 'country_line_dancing', 'making_cheese', 'popping_balloons', 'using_circular_saw', 'shining_flashlight', 'grinding_meat', 'clean_and_jerk', 'playing_ping_pong', 'uncorking_champagne', 'playing_basketball', 'playing_piccolo', 'cutting_pineapple', 'milking_cow', 'shuffling_cards', 'hand_washing_clothes', 'water_sliding', 'yoga', 'sawing_wood', 'exercising_with_an_exercise_ball', 'egg_hunting', 'ice_climbing', 'jumping_sofa', 'planing_wood', 'bungee_jumping', 'building_cabinet', 'drumming_fingers', 'sleeping', 'curling_(sport)', 'baby_waking_up', 'chasing', 'contact_juggling', 'grooming_cat', 'doing_laundry', 'cosplaying', 'polishing_metal', 'lighting_candle', 'bottling', 'embroidering', 'feeding_goats', 'moving_furniture', 'playing_monopoly', 'peeling_banana', 'slapping', 'climbing_tree', 'golf_driving', 'archaeological_excavation', 'hammer_throw', 'opening_present', 'recording_music', 'steering_car', 'scrapbooking', 'sword_fighting', 'playing_ukulele', 'opening_bottle_(not_wine)', 'playing_laser_tag', 'playing_violin', 'mixing_colours', 'skiing_mono', 'clam_digging', 'cracking_neck', 'bouncing_ball_(not_juggling)', 'trimming_or_shaving_beard', 'combing_hair', 'trimming_trees', 'exercising_arm', 'capoeira', 'crying', 'air_drumming', 'playing_dominoes', 'reading_book', 'historical_reenactment', 'throwing_ball_(not_baseball_or_American_football)', 'shooting_off_fireworks', 'dunking_basketball', 'making_a_cake', 'chewing_gum', 'front_raises', 'herding_cattle', 'grooming_horse', 'tickling', 'karaoke', 'stacking_cups', 'riding_mechanical_bull', 'catching_or_throwing_softball', 'looking_in_mirror', 'cooking_chicken', 'licking', 'washing_dishes', 'spray_painting', 'cutting_cake', 'making_latte_art', 'sharpening_knives', 'dyeing_eyebrows', 'putting_on_mascara', 'stretching_arm', 'flipping_pancake', 'using_bagging_machine', 'huddling', 'breathing_fire', 'dancing_ballet', 'gymnastics_tumbling', 'bartending', 'diving_cliff', 'land_sailing', 'opening_coconuts', 'playing_scrabble', 'being_excited', 'shaping_bread_dough', 'using_puppets', 'smelling_feet', 'home_roasting_coffee', 'drooling', 'tapping_pen', 'putting_on_foundation', 'picking_apples', 'smashing', 'making_bubbles', 'finger_snapping', 'tapping_guitar', 'wrapping_present', 'spraying', 'playing_pinball', 'swing_dancing', 'tying_shoe_laces', 'cleaning_pool', 'tossing_salad', 'head_stand', 'playing_accordion', 'vacuuming_floor', 'waxing_back', 'marching', 'roasting_pig', 'falling_off_bike', 'lifting_hat', 'fencing_(sport)', 'alligator_wrestling', 'juggling_fire', 'surfing_water', 'petting_horse', 'jumping_bicycle', 'tai_chi', 'waxing_eyebrows', 'wading_through_mud', 'steer_roping', 'using_segway', 'throwing_tantrum', 'baking_cookies', 'high_kick', 'using_megaphone', 'water_skiing', 'zumba', 'moon_walking', 'sailing', 'shooting_goal_(soccer)', 'swinging_on_something', 'driving_tractor', 'putting_on_eyeliner', 'shopping', 'mopping_floor', 'waking_up', 'helmet_diving', 'making_snowman', 'waxing_legs', 'playing_badminton', 'jogging', 'swimming_backstroke', 'beatboxing', 'cracking_back', 'sieving', 'riding_a_bike', 'playing_rounders', 'shaving_legs', 'pirouetting', 'shucking_oysters', 'peeling_apples', 'letting_go_of_balloon', 'sanding_floor', 'playing_cello', 'snorkeling', 'cooking_egg', 'kitesurfing', 'shoveling_snow', 'tossing_coin', 'acting_in_play', 'catching_or_throwing_frisbee', 'using_a_power_drill', 'standing_on_hands', 'ski_jumping', 'seasoning_food', 'carving_wood_with_a_knife', 'jumping_into_pool', 'checking_tires', 'getting_a_haircut', 'feeding_birds', 'marriage_proposal', 'casting_fishing_line', 'skiing_slalom', 'blowdrying_hair', 'carving_ice', 'picking_blueberries', 'giving_or_receiving_award', 'chopping_meat', 'playing_controller', 'pushing_wheelbarrow', 'abseiling', 'ski_ballet', 'gargling', 'contorting', 'playing_drums', 'robot_dancing', 'listening_with_headphones', 'moving_child', 'climbing_ladder', 'shaking_head', 'smoking', 'burping', 'curling_hair', 'sewing', 'petting_animal_(not_cat)', 'breading_or_breadcrumbing', 'falling_off_chair', 'poaching_eggs', 'testifying', 'hockey_stop', 'salsa_dancing', 'photocopying', 'changing_wheel_(not_on_bike)', 'doing_aerobics', 'passing_soccer_ball', 'putting_on_lipstick', 'riding_camel', 'carving_marble', 'drinking_shots', 'sharpening_pencil', 'checking_watch', 'catching_fish', 'looking_at_phone', 'skipping_rope', 'tightrope_walking', 'playing_chess', 'bouncing_on_trampoline', 'walking_the_dog', 'bathing_dog', 'using_a_paint_roller', 'kicking_soccer_ball', 'swimming_with_dolphins', 'ice_swimming', 'blowing_nose', 'dancing_gangnam_style', 'card_stacking', 'playing_tennis', 'blowing_bubble_gum', 'brush_painting', 'cutting_nails', 'pulling_rope_(game)', 'crossing_eyes', 'juggling_soccer_ball', 'splashing_water', 'news_anchoring', 'curling_eyelashes', 'roller_skating', 'swinging_baseball_bat', 'pillow_fight', 'bandaging', 'using_a_wrench', 'scrubbing_face', 'playing_poker', 'clay_pottery_making']
SSV2_LABELS = ['Approaching something with your camera', 'Attaching something to something', 'Bending something so that it deforms', 'Bending something until it breaks', 'Burying something in something', 'Closing something', 'Covering something with something', 'Digging something out of something', 'Dropping something behind something', 'Dropping something in front of something', 'Dropping something into something', 'Dropping something next to something', 'Dropping something onto something', 'Failing to put something into something because something does not fit', 'Folding something', 'Hitting something with something', 'Holding something', 'Holding something behind something', 'Holding something in front of something', 'Holding something next to something', 'Holding something over something', 'Laying something on the table on its side, not upright', 'Letting something roll along a flat surface', 'Letting something roll down a slanted surface', 'Letting something roll up a slanted surface, so it rolls back down', 'Lifting a surface with something on it but not enough for it to slide down', 'Lifting a surface with something on it until it starts sliding down', 'Lifting something up completely without letting it drop down', 'Lifting something up completely, then letting it drop down', 'Lifting something with something on it', 'Lifting up one end of something without letting it drop down', 'Lifting up one end of something, then letting it drop down', 'Moving away from something with your camera', 'Moving part of something', 'Moving something across a surface until it falls down', 'Moving something across a surface without it falling down', 'Moving something and something away from each other', 'Moving something and something closer to each other', 'Moving something and something so they collide with each other', 'Moving something and something so they pass each other', 'Moving something away from something', 'Moving something away from the camera', 'Moving something closer to something', 'Moving something down', 'Moving something towards the camera', 'Moving something up', 'Opening something', 'Picking something up', 'Piling something up', 'Plugging something into something', 'Plugging something into something but pulling it right out as you remove your hand', 'Poking a hole into some substance', 'Poking a hole into something soft', 'Poking a stack of something so the stack collapses', 'Poking a stack of something without the stack collapsing', 'Poking something so it slightly moves', "Poking something so lightly that it doesn't or almost doesn't move", 'Poking something so that it falls over', 'Poking something so that it spins around', 'Pouring something into something', 'Pouring something into something until it overflows', 'Pouring something onto something', 'Pouring something out of something', 'Pretending or failing to wipe something off of something', 'Pretending or trying and failing to twist something', 'Pretending to be tearing something that is not tearable', 'Pretending to close something without actually closing it', 'Pretending to open something without actually opening it', 'Pretending to pick something up', 'Pretending to poke something', 'Pretending to pour something out of something, but something is empty', 'Pretending to put something behind something', 'Pretending to put something into something', 'Pretending to put something next to something', 'Pretending to put something on a surface', 'Pretending to put something onto something', 'Pretending to put something underneath something', 'Pretending to scoop something up with something', 'Pretending to spread air onto something', 'Pretending to sprinkle air onto something', 'Pretending to squeeze something', 'Pretending to take something from somewhere', 'Pretending to take something out of something', 'Pretending to throw something', 'Pretending to turn something upside down', 'Pulling something from behind of something', 'Pulling something from left to right', 'Pulling something from right to left', 'Pulling something onto something', 'Pulling something out of something', 'Pulling two ends of something but nothing happens', 'Pulling two ends of something so that it gets stretched', 'Pulling two ends of something so that it separates into two pieces', 'Pushing something from left to right', 'Pushing something from right to left', 'Pushing something off of something', 'Pushing something onto something', 'Pushing something so it spins', "Pushing something so that it almost falls off but doesn't", 'Pushing something so that it falls off the table', 'Pushing something so that it slightly moves', 'Pushing something with something', 'Putting number of something onto something', 'Putting something and something on the table', 'Putting something behind something', 'Putting something in front of something', 'Putting something into something', 'Putting something next to something', 'Putting something on a flat surface without letting it roll', 'Putting something on a surface', 'Putting something on the edge of something so it is not supported and falls down', "Putting something onto a slanted surface but it doesn't glide down", 'Putting something onto something', 'Putting something onto something else that cannot support it so it falls down', 'Putting something similar to other things that are already on the table', "Putting something that can't roll onto a slanted surface, so it slides down", "Putting something that can't roll onto a slanted surface, so it stays where it is", 'Putting something that cannot actually stand upright upright on the table, so it falls on its side', 'Putting something underneath something', 'Putting something upright on the table', 'Putting something, something and something on the table', 'Removing something, revealing something behind', 'Rolling something on a flat surface', 'Scooping something up with something', 'Showing a photo of something to the camera', 'Showing something behind something', 'Showing something next to something', 'Showing something on top of something', 'Showing something to the camera', 'Showing that something is empty', 'Showing that something is inside something', 'Something being deflected from something', 'Something colliding with something and both are being deflected', 'Something colliding with something and both come to a halt', 'Something falling like a feather or paper', 'Something falling like a rock', 'Spilling something behind something', 'Spilling something next to something', 'Spilling something onto something', 'Spinning something so it continues spinning', 'Spinning something that quickly stops spinning', 'Spreading something onto something', 'Sprinkling something onto something', 'Squeezing something', 'Stacking number of something', 'Stuffing something into something', 'Taking one of many similar things on the table', 'Taking something from somewhere', 'Taking something out of something', 'Tearing something into two pieces', 'Tearing something just a little bit', 'Throwing something', 'Throwing something against something', 'Throwing something in the air and catching it', 'Throwing something in the air and letting it fall', 'Throwing something onto a surface', "Tilting something with something on it slightly so it doesn't fall down", 'Tilting something with something on it until it falls off', 'Tipping something over', 'Tipping something with something in it over, so something in it falls out', 'Touching (without moving) part of something', "Trying but failing to attach something to something because it doesn't stick", 'Trying to bend something unbendable so nothing happens', 'Trying to pour something into something, but missing so it spills next to it', 'Turning something upside down', 'Turning the camera downwards while filming something', 'Turning the camera left while filming something', 'Turning the camera right while filming something', 'Turning the camera upwards while filming something', 'Twisting (wringing) something wet until water comes out', 'Twisting something', 'Uncovering something', 'Unfolding something', 'Wiping something off of something']
UCF101_LABELS = ['Kayaking', 'PlayingDaf', 'BoxingSpeedBag', 'GolfSwing', 'Diving', 'PlayingFlute', 'TrampolineJumping', 'BabyCrawling', 'Drumming', 'RockClimbingIndoor', 'Biking', 'MoppingFloor', 'Haircut', 'SalsaSpin', 'PlayingPiano', 'HandstandWalking', 'Billiards', 'Nunchucks', 'SoccerJuggling', 'VolleyballSpiking', 'Skijet', 'LongJump', 'UnevenBars', 'ApplyEyeMakeup', 'SoccerPenalty', 'BandMarching', 'BlowingCandles', 'PizzaTossing', 'ApplyLipstick', 'HandstandPushups', 'CricketShot', 'FrisbeeCatch', 'PushUps', 'FieldHockeyPenalty', 'ThrowDiscus', 'PlayingGuitar', 'JugglingBalls', 'HorseRiding', 'PlayingViolin', 'JumpingJack', 'PoleVault', 'BoxingPunchingBag', 'FloorGymnastics', 'RopeClimbing', 'JumpRope', 'ParallelBars', 'BodyWeightSquats', 'HorseRace', 'BasketballDunk', 'BlowDryHair', 'SkyDiving', 'BalanceBeam', 'IceDancing', 'SumoWrestling', 'Bowling', 'TennisSwing', 'MilitaryParade', 'Lunges', 'Swing', 'HighJump', 'StillRings', 'Skiing', 'HeadMassage', 'JavelinThrow', 'HammerThrow', 'Hammering', 'BaseballPitch', 'Shotput', 'Basketball', 'PommelHorse', 'Punch', 'TableTennisShot', 'SkateBoarding', 'Typing', 'Rafting', 'WritingOnBoard', 'PlayingSitar', 'Archery', 'PlayingTabla', 'TaiChi', 'BreastStroke', 'ShavingBeard', 'CricketBowling', 'Rowing', 'CliffDiving', 'CleanAndJerk', 'PullUps', 'PlayingDhol', 'YoYo', 'FrontCrawl', 'WallPushups', 'WalkingWithDog', 'Knitting', 'Mixing', 'HulaHoop', 'BrushingTeeth', 'Surfing', 'PlayingCello', 'BenchPress', 'CuttingInKitchen', 'Fencing']
HMDB51_LABELS = ['ride_bike', 'wave', 'dive', 'pour', 'smile', 'eat', 'shoot_ball', 'clap', 'chew', 'brush_hair', 'pushup', 'draw_sword', 'pullup', 'catch', 'somersault', 'sit', 'hug', 'kick_ball', 'golf', 'cartwheel', 'turn', 'kick', 'dribble', 'jump', 'sword_exercise', 'drink', 'shoot_gun', 'hit', 'ride_horse', 'smoke', 'fencing', 'climb', 'situp', 'handstand', 'talk', 'kiss', 'push', 'shake_hands', 'swing_baseball', 'stand', 'flic_flac', 'sword', 'run', 'laugh', 'walk', 'throw', 'punch', 'climb_stairs', 'pick', 'shoot_bow', 'fall_floor']

VIDEOCLS_LABEL_MAPPING = {
    'Kinetics-700': K700_LABELS,
    'SmthSmthV2': SSV2_LABELS,
    'UCF101': UCF101_LABELS,
    'HMDB51': HMDB51_LABELS,
    'Breakfast': BREAKFAST_LABELS
}

DATASET_INSTRUCTION = {
    'Kinetics-700': 'Recognize the category of the video content.',
    'SmthSmthV2': 'What actions or object interactions are being performed by the person in the video?',
    'UCF101': 'What activities or sports are being performed by the person in the video?',
    'HMDB51': 'What actions or objects interactions are the person in the video doing?',
    'Breakfast': 'Recognize the breakfast type that the person is cooking in the video. '
}
