#!/bin/bash
export CUDA_VISIBLE_DEVICES=0
DIST=uniform
Learner=FairDICE
Divergence=SOFT_CHI
for ENV in MO-Hopper-v2 MO-Walker2d-v2 MO-Swimmer-v2 MO-HalfCheetah-v2 MO-Ant-v2 MO-Hopper-v3; do
    for quality in expert amateur; do
        for beta in 1 0.1 0.01 0.001 0.0001; do
            for seed in 1 2 3 4 5; do
                echo "Running $Learner $ENV $quality $beta $seed"
                if [ "$ENV" == "MO-Hopper-v3" ]; then
                    num_layers=4
                else 
                    num_layers=3
                fi 
                if [ "$ENV" == "MO-Ant-v2" ]; then
                    hidden_dim=512
                else
                    hidden_dim=768
                fi
                python main.py \
                    --learner $Learner \
                    --divergence $Divergence \
                    --env_name $ENV \
                    --quality $quality \
                    --beta $beta \
                    --seed $seed \
                    --preference_dist $DIST \
                    --eval_episodes 10 \
                    --batch_size 256 \
                    --hidden_dim $hidden_dim \
                    --num_layers $num_layers \
                    --total_train_steps 100000 \
                    --log_interval 1000 \
                    --normalize_reward True
            done
        done
    done
done
