## Setup Python Virtual Environment
1. Make sure you have [downloaded & installed (mini)conda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/linux.html) before proceeding.
2. Create conda environment and install the packages:
```
mkdir ./save_model
mkdir ./evaluate_model
conda env create -n cn-py37 python=3.7 -f python_environment.yml
conda activate cn-py37
```
3. Install [Pytorch (version==1.21.1)](https://pytorch.org/) in the conda env.

##  Setup MuJoCo
To run the virtual environment, you need to set up MuJoCo.
1. Download the MuJoCo version 2.1 binaries for Linux or OSX. 
2. Extract the downloaded mujoco210 directory into ~/.mujoco/mujoco210.
3. Install and use [mujoco-py](https://github.com/openai/mujoco-py).
```
pip install -U 'mujoco-py<2.2,>=2.1'
pip install -e ./mujuco_environment
```
We **highly recommend** you to ensure the MuJoCo is indeed working by running testing examples in [mujoco-py](https://github.com/openai/mujoco-py). In most case, you need to run:
```
import mujoco_py
import os
mj_path = mujoco_py.utils.discover_mujoco()
xml_path = os.path.join(mj_path, 'model', 'humanoid.xml')
model = mujoco_py.load_model_from_path(xml_path)
sim = mujoco_py.MjSim(model)
```

## Run Six Exploration Strategies in Gridworld Environments
1. uniform sampling: python train_icrl.py ../config/mujoco_WGW-discrete-v0/train_ICRL_discrete_WGW-v0-setting1.yaml
2. BEAR: python train_icrl_BEAR.py ../config/mujoco_WGW-discrete-v0/train_ICRL_discrete_WGW-v0-setting1.yaml
3. epsilon_greedy: python train_icrl_epsilon_greedy.py ../config/mujoco_WGW-discrete-v0/train_ICRL_discrete_WGW-v0-setting1.yaml
4. PCSE: python train_icrl_PCSE.py ../config/mujoco_WGW-discrete-v0/train_ICRL_discrete_WGW-v0-setting1.yaml
5. maximum_entropy_exploration: python train_icrl_ME.py ../config/mujoco_WGW-discrete-v0/train_ICRL_discrete_WGW-v0-setting1.yaml
6. upper_confidence_bound: python train_icrl_UCB.py ../config/mujoco_WGW-discrete-v0/train_ICRL_discrete_WGW-v0-setting1.yaml

## Four Gridworld Settings
Change the .yaml with the following .yamls
1. Gridworld-1: train_ICRL_discrete_WGW-v0-setting1.yaml
2. Gridworld-2: train_ICRL_discrete_WGW-v0-setting2.yaml
3. Gridworld-3: train_ICRL_discrete_WGW-v0-setting3.yaml
4. Gridworld-4: train_ICRL_discrete_WGW-v0-setting4.yaml

## Continuous Setting
python maze_icrl_PCSE.py
python maze_icrl_BEAR.py

