import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
import time

###Parameters

TEnd = 24*60 #en minutes
dt = 15   #en minutes
Nt=int(TEnd/dt)

T_amb = 15
Tmin=50
Tmax=65

vol = 0.3         # Volume in m3
height = 1.37      # Height in m
EI = 0.035         # Thickness of isolation (in m)
EI = EI/4
powerRes = 2200    # Heat resistance power in W
Pmax = 60*powerRes           # Energy injected during one timestep (in minutes)

T_floor = 0
rho = 1000                     # water density in kg.m-3
capWater = 4185                # heat capacity of water in J.kg-1.K-1
CI = 0.033                     # heat conductivity isolant in W/(m K)
Sect = vol/height
ray = np.sqrt(Sect/3.14)                              # Radius in m
coefLoss = CI/EI * 2 * 3.14 * ray           # loss coeff in W/(K m)

lossH = (coefLoss*60)/(capWater * rho * Sect)  # Fraction of heat loss by minutes
e_unit = vol * rho * capWater               #J.K-1

NP=20
Td=np.linspace(0,Nt,Nt)
PowerD=np.linspace(0,NP,NP)*np.ones((Nt,NP))/NP

def c(x,y):
    return(np.sum((x[1]-y[1])**2))

#Loi drain

def f(t):
    #return(((t-12*60)**2)/5000000-((t-60*19)**2)/10000000+0.05)
    x=t/120
    Toreturn=-2.065*(10**(-6))*(x**5)+0.00011*(x**4)-0.00209502*(x**3)+0.0159225*(x**2)-0.0384359*x+0.03+(0.001778118231379966)*x
    return(Toreturn*1.5)

def plotf():
    listT=np.linspace(0,TEnd,10000)
    plt.plot(listT/60,f(listT))
    plt.grid()
    plt.xlabel("Time")
    plt.ylabel("Volume per minute (in liters)")


### Simulation nominale

def nextT(t,m,T):
    loss=-lossH*(T-T_amb)
    heating=m*Pmax/ e_unit
    drain=-(T-T_floor)*f(t)/(vol*1000)
    return(T+dt*(loss+heating+drain))

def nextM(t,m,T):
    a=np.random.random()
    if a<density(t,m,T):
        return(1-m)
    else:
        return(m)

def trajectoire(Tinit,minit):
    Traj=np.zeros((3,int(Nt)))
    Traj[:,0]=[0,minit,Tinit]
    for i in range(1,Nt):
        t,m,T=Traj[:,i-1]
        Traj[:,i]=[i*dt,nextM(t*dt,m,T),nextT(t*dt,m,T)]
    return(Traj)

def CreatingSignal(N):
    r=np.zeros((Nt))
    for i in range(N):
        t,m,T=densityInit()
        r+=trajectoire(T,m)[1]
        print(i)
    return(r)

### Different density    

def density(t,m,T):
    return(densityNom(t,m,T))

def densityClassic(t,m,T):
    if m==1:
        if T>Tmax:
            return(1)
        else:
            return(0)
    if m==0:
        if T<Tmin:
             return(1)
        else:
             return(0)

A=20

def densityNom(t,m,T):
    if m==1:
        if T>Tmax:
            return(1)
        else:
            return(np.exp(A*(T-Tmax)/(Tmax-Tmin)))
    if m==0:
        if T<Tmin:
             return(1)
        else:
             return(np.exp(A*(Tmin-T)/(Tmax-Tmin)))

p,q=1/200,1/400

def densityTest(t,m,T):
    if m==1:
        if T>Tmax:
            return(1)
        else:
            return(p)
    if m==0:
        if T<Tmin:
             return(1)
        else:
             return(q)

def fProb(m1,m2):
    return(1-q+(2*q-1)*m2+(q+p-1)*m1+m1*m2*(2-2*p-2*q))

NTemperature=1000

listPTemp=np.zeros(NTemperature)
listPTemp[0:180]+=np.linspace(0.035,0.11,180)
listPTemp[180:970]+=np.linspace(0.11,0.095,970-180)
listPTemp[970:]+=np.linspace(0.095,0.07,30)
listPTemp=listPTemp/np.sum(listPTemp)

def densityInit():
    return([0,np.random.binomial(1,0.38),np.random.choice(np.linspace(Tmin,Tmax,NTemperature),p=listPTemp)])

def plotDensity(dens):
    l=np.linspace(Tmin-5,Tmax+5,1000)
    for t in range(Nt):
        L=np.zeros(1000)
        for T in range(1000):
            L[T]=dens(t*dt,0,l[T])
        plt.plot(l,L)
    plt.title("Mode 0")
    plt.axis([Tmin-5,Tmax+5,0,1])
    plt.grid()
    plt.show()
    for t in range(Nt):
        L=np.zeros(1000)
        for T in range(1000):
            L[T]=dens(t*dt,1,l[T])
        plt.plot(l,L)
    plt.title("Mode 1")
    plt.axis([Tmin-5,Tmax+5,0,1])
    plt.grid()
    plt.show()

###TRAJ WITH MATRIX

def indiceT(T,NTemperature):
    if T>Tmax:
        return(NTemperature-1)
    elif T<Tmin:
        return(0)
    else:
        return(round((T-Tmin)/dTemperature))


dTemperature=(Tmax-Tmin)/(NTemperature-1)
ProbNom=np.zeros((Nt,2,2,NTemperature))

for t in range(Nt):
    for i in range(2):
        for T in range(NTemperature):
            ProbNom[t,i,1-i,T]=densityNom(t*dt,i,T*dTemperature+Tmin)
            ProbNom[t,i,i,T]=1-ProbNom[t,i,1-i,T]

def TransProb():
    TransitionProb=np.zeros((Nt,2,NTemperature))
    for t in range(Nt):
        for i in range(2):
            for iT1 in range(NTemperature):
                iT2=indiceT(nextT(t*dt,i,iT1*dTemperature+Tmin),NTemperature)
                TransitionProb[t,i,iT2]+=1
    return(TransitionProb)

def plotProb(Prob,i,j):
    hm=plt.imshow(np.transpose(Prob[:,i,j]), cmap='Blues',interpolation="nearest",origin='lower',aspect='auto',extent=[0,24,Tmin,Tmax])
    plt.colorbar(hm)
    plt.title('from '+str(i)+' to ' + str(j))
    plt.xlabel('Time')
    plt.ylabel('Temperature')
    plt.show()

def densityMarkov(Prob,t,m,T):
    if m==1:
        if T>Tmax:
            return(1)
        else:
            return(Prob[int(t/dt),1,0,indiceT(T,NTemperature)])
    if m==0:
        if T<Tmin:
             return(1)
        else:
             return(Prob[int(t/dt),0,1,indiceT(T,NTemperature)])

def nextMMarkov(Prob,t,m,T):
    a=np.random.random()
    if a<densityMarkov(Prob,t,m,T):
        return(1-m)
    else:
        return(m)

def TrajMarkov(Prob,Tinit,minit):
    Traj=np.zeros((3,int(Nt)))
    Traj[:,0]=[0,minit,Tinit]
    for i in range(1,Nt):
        t,m,T=Traj[:,i-1]
        Traj[:,i]=[i*dt,nextMMarkov(Prob,int(t/dt),m,T),nextT(t,m,T)]
    return(Traj)

def GenerateMMarkov(n,Prob):
    ListTraj=[]
    for i in range(n):
        t,m,T=densityInit()
        ListTraj.append(TrajMarkov(Prob,T,m))
    return(np.array(ListTraj)[:,1])

def TrajMarkov2(Prob,Tinit,minit,tinit=0):
    Traj=np.zeros((3,int(Nt)-tinit))
    Traj[:,0]=[tinit,minit,indiceT(Tinit,NTemperature)*dTemperature+Tmin]
    for i in range(1,Nt-tinit):
        t,m,T=Traj[:,i-1]
        Traj[:,i]=[i*dt,nextMMarkov(Prob,int(t/dt),m,T),indiceT(nextT(t,m,T), NTemperature)*dTemperature+Tmin]
    return(Traj)

def GenerateMMarkov2(n,Prob):
    ListTraj=[]
    for i in range(n):
        t,m,T=densityInit()
        Ti=indiceT(T, NTemperature)*dTemperature+Tmin
        Traj=TrajMarkov2(Prob,Ti,m,tinit=t)
        ListTraj.append(Traj)
    return(np.array(ListTraj)[:,1])

def GenerateTMarkov2(n,Prob):
    ListTraj=[]
    for i in range(n):
        t,m,T=densityInit()
        Ti=indiceT(T, NTemperature)*dTemperature+Tmin
        Traj=TrajMarkov2(Prob,Ti,m,tinit=t)
        ListTraj.append(Traj)
    return(np.array(ListTraj)[:,2])

def ProbLambda(ProbNom,lbda):
    Prob=np.zeros(np.shape(ProbNom))
    NTemperature=len(ProbNom[0,0,0])
    for k in range(0,Nt-1):
        for x in range(2):
            Prob[k,:,x]=ProbNom[k,:,x]*np.exp(lbda[k+1]*x)
    a=np.zeros((Nt,2,NTemperature))
    a[-1]+=1
    for k in range(Nt-1,0,-1):
        for x in range(2):
            for T in range(NTemperature):
                a[k-1,x,T]=np.dot(a[k,:,T],Prob[k-1,x,:,T])
    for k in range(Nt-1):
        for x in range(2):
            for y in range(2):
                for T in range(NTemperature-1):
                    Prob[k,x,y,T]=(1/a[k,x,T])*Prob[k,x,y,T]*a[k+1,y,T]
    return(Prob)

def TrajMarkov2FromX(Prob,x,Time,tinit=0):
    Traj=np.zeros((3,int(Nt)-tinit))
    Traj[:,0]=x[:,0]
    for i in range(1,Nt-tinit):
        t,m,T=Traj[:,i-1]
        if i in Time:
            Traj[:,i]=[i*dt,1-nextMMarkov(Prob,int(t/dt),m,T),indiceT(nextT(t,m,T), NTemperature)*dTemperature+Tmin]
        else:
            Traj[:,i]=[i*dt,nextMMarkov(Prob,int(t/dt),m,T),indiceT(nextT(t,m,T), NTemperature)*dTemperature+Tmin]
    return(Traj)

###Trajectories

def plotTraj(Traj,Tmin=Tmin,Tmax=Tmax):
    plt.axis([Traj[0,0],Traj[0,-1]/60,Tmin,Tmax])
    plt.scatter(Traj[0]/60,Traj[2],c=cm.bwr(Traj[1]),marker='.')
    plt.grid(True)
    plt.xlabel("Time (in h)")
    plt.ylabel("Temperature (in C)")

###Useful functions

def DrawX():
    t,m,T=densityInit()
    return(TrajMarkov2(ProbNom,T,m))

def gradJ(N,M,lbda,r,Epsilon):
    s=0
    for i in range(N):
        #print(i)
        x=DrawX()
        s1=x[1]*np.exp(np.sum(lbda*(x[1]-r)))
        s2=np.exp(np.sum(lbda*(x[1]-r)))
        for j in range(M): #M
            nbTime=2
            Time=np.random.randint(1,Nt-1,nbTime)
            #Time=[j]
            y=TrajMarkov2FromX(ProbNom, x, Time)
            s1+=y[1]*np.exp(np.sum(lbda*(y[1]-r))-c(x,y)/Epsilon)
            s2+=np.exp(np.sum(lbda*(y[1]-r))-c(x,y)/Epsilon)
        s+=s1/s2
    return(s/N)
    
###Display

def plotResult(r,G,rangeR):
    plt.plot(24*Td/Nt,R1,label='Nominal')
    plt.plot((24*Td/Nt)[rangeR],r[rangeR],label="Reference")
    plt.plot((24*Td/Nt),G,label='Aggregated consumption')
    plt.legend()
    plt.grid()
    plt.xlabel("Time (in h)")
    plt.ylabel("Power (normalized)")
    plt.show()
    
###Algo

lbd0=np.zeros(Nt)

def prho(k):
    return(3*min(1,10/((1+k)**0.7)))

R1=np.mean([DrawX()[1] for i in range(10000)],0)

R2=R1+np.sin(2*np.pi*Td/Nt)*0.05
#R2[46:]=R2[46:]*0.5+0.5*np.mean(R2[46:])
R3=np.mean(R1)+0*Td

def Algo(Epsilon,r,N,M,rangeR=range(Nt),Klimit=10000,plot=True,prin=True,lbd0A=lbd0):
    lbda=lbd0A.copy()
    k=0
    G=1
    t0=time.time()
    while k<Klimit and np.linalg.norm((G-r)[rangeR])>0.0001:
        G=gradJ(N,M, lbda, r,Epsilon)
        lbda[rangeR]+=-prho(k)*((G-r)[rangeR])
        k+=1
        if plot:
            #plt.plot(lbda)
            #plt.grid()
            #plt.show()
            plotResult(r,G,rangeR=rangeR)
        if prin:
            print("Step "+str(k)+ " " +str(np.linalg.norm((G-r)[rangeR]))+ " in " + str(int(time.time()-t0)) + "s")
        np.save("lbdaAlgo.npy",lbda)
    return(lbda)

def CompareMonteCarlo(rangeN):
    l=[]
    for N in rangeN:
        print(N)
        lbdaList=Algo(0.1,R1,N,30,Klimit=1000)
        l.append(lbdaList)
    return(l)
        
        
