import os
from omegaconf import OmegaConf
import random

from IntentGPT import IntentGPT

def main(args):
    intentGPT = IntentGPT(args)
    if args.only_validate_results:
        intentGPT.validate(args.only_validate_results)
    else:
        intentGPT.run()
        intentGPT.validate()

if __name__ == "__main__":
    
    cli_conf = OmegaConf.from_cli()
    specific_conf = OmegaConf.load(cli_conf.pop('config')) if 'config' in cli_conf else {}
    exp_dict = OmegaConf.merge(specific_conf, cli_conf)
    random.seed(exp_dict.seed)
    main(exp_dict)
