# Paper 2744: Comfetch: Federated Learning of Large Networks on Constrained Clients via Sketching

Developed on Python 3.8.10
Developed on Pytorch 1.14.0
Developed on cuda 11.1.1
## Comfetch training
Requires mpi. 

To perform a Comfetch run with 4 workers and cr=0.5 and 200 epoch, for example: 
```
mpirun -n 4 python main.py --cr 0.5 --epochs 200
```

Refer to main.py for other arguments/settings. 

## Pruning experiments 

### Tutorial
To run the same experiments locally follow the steps below.

#### Command Arguments
Below are the arguments that can be passed to comfetch_prune.py
```
parser.add_argument('--norm', default="bn")
parser.add_argument('--partition', default="iid")
parser.add_argument('--client_number', default=100)
parser.add_argument('--alpha_partition', default=0.001)
parser.add_argument('--commrounds', type=int, default=200)
parser.add_argument('--clientfr', type=float, default=1.0)
parser.add_argument('--numclient', type=int, default=4)
parser.add_argument('--clientepochs', type=int, default=1)
parser.add_argument('--clientbs', type=int, default=128)
parser.add_argument('--clientlr', type=float, default=0.001)
parser.add_argument('--sch_flag', default=False)
parser.add_argument('--save', action="store_true")
parser.add_argument('--natural_image_path', default="./stylegan-oriented/train")
parser.add_argument('--cr', type=float, default=0.5)
parser.add_argument('--prune_type', default="random")
```

#### Example Command
You can run the experiment with the following example command. The options for prune_type are 'l1' and 'random'. The options for cr (compression rate) are any float.
```
python comfetch_prune.py --mixup_prop=0.0 --natural_img_prop=0.0 --natural_image_path="./stylegan-oriented/train"
