# Neural Monge map and its applications

## Installation

```bash
pip install torch torchvision torchaudio --extra-index-url https://download.pytorch.org/whl/cu113

pip install --no-deps -r requirements.txt
```

## Repository structure

The repository highly depends on the [pytorch-lightning template](https://github.com/ashleve/lightning-hydra-template). The hyper-parameters are stored in `configs/`.

The commands to run the experiments are stored in `bash/`. For example, to run the inpainting experiment, run

```bash
python run.py name=celeb_64 experiment=inpainting_celeb64 model.n_inner_iter=5 model.coeff_mse=10000. trainer.devices="[0]" logger=wandb

python run.py name=celeb_128 experiment=inpainting_celeb128 model.n_inner_iter=10 trainer.devices="[0]" logger=wandb

```

The outputs are saved in folder `logs`.

See the [config](configs/experiment) for more experiment configs.
