import matplotlib.pyplot as plt
import numpy as np


def plot_histogram(samples, num_class=100, path="hist.jpg"):
    fig, ax = plt.subplots(nrows=1, ncols=1, figsize=(4, 3), facecolor="w")
    ax.hist(
        np.array(samples),
        bins=num_class,
        range=(0, num_class),
        density=True,
        color="gold",
    )
    fig.savefig(path, bbox_inches="tight", dpi=50)
