#!/bin/bash

mkdir -p logs

tasks=("math500")
MODEL_NAME="meta-llama/Llama-3.1-8B-Instruct"
INPUT_DIR="result"
OUTPUT_DIR="likelihood"

for task in "${tasks[@]}"; do
  for gpt in 'gpt-4o-mini' 'gpt-4o'; do
    sbatch --job-name="${task}_${gpt}" \
            --output="logs/${task}_${gpt}_${seed}.txt" \
            --time=72:00:00 \
            --gres=gpu:1 \
            --partition=suma_a6000 \
            --wrap="source ~/.bashrc; conda activate proj2; \
                    python -u ${task}/${task}_likelihood_gpt.py \
                    --model ${gpt} \
                    --model_name ${MODEL_NAME} \
                    --task ${task} \
                    --input_dir ${INPUT_DIR} \
                    --output_dir ${OUTPUT_DIR}"
  done

done
