#!/bin/bash

GPUID=$1
RANDOM_SEED=$2
DATASET=$3
LM_STEP=$4


DATA_ROOT=./datasets/$DATASET
CONFIG_ROOT=./configuration/$DATASET
OUTPUT_ROOT=$DATASET\_$RANDOM_SEED\_$LM_STEP\_step
PRETRAINED_NLG_LM=t5_large_meta_dist_deepspeed_dual_task_wo_SuperGLUE
HOST=master

MASTER_PORT=$(($RANDOM % 99999))

mkdir -p $OUTPUT_ROOT

deepspeed --include=$HOST:$GPUID --master_port $MASTER_PORT meta_t5_DA.py --config $CONFIG_ROOT/nlg_meta.yml --serialization-dir $OUTPUT_ROOT/nlg_da --start-from-checkpoint $PRETRAINED_NLG_LM \
           --config-override output_as_json True load_from_pretrained True enable_new_task_embeddings True enable_pretrain_task_embeddings True task_type_vector_count_per_layer 5 learning_rate 5e-6 val_batch_size 32 random_seed $RANDOM_SEED eval_data_replication 50 sample_num 3 running_task wsc_generation train_path $DATA_ROOT/train.jsonl dev_path  $DATA_ROOT/train.jsonl checkpoint_every_step 500 num_training_steps $LM_STEP \
           --train --output-path $OUTPUT_ROOT/wsc_da.jsonl --deepspeed

