#!/bin/bash

GPUID=$1
RANDOM_SEED=$2
DATASET=$3
LR=$4
BATCH_SIZE=$5
EVAl_PER_STEPS=$6
TRAIN_STEPS=$7
IN_CONTEXT=$8


OUTPUT_ROOT=SuperGLUE_$DATASET\_$RANDOM_SEED
PRETRAINED_NLG_LM=t5_large_meta_dist_deepspeed_dual_task_wo_SuperGLUE

[ -d $OUTPUT_ROOT ] || mkdir $OUTPUT_ROOT

MASTER_PORT=$(($RANDOM % 99999))
deepspeed --include=master:$GPUID --master_port $MASTER_PORT \
		meta_t5_DA.py --config $DATASET\_nlu.yml --serialization-dir $OUTPUT_ROOT/meta_nlu_few_shot_data \
					  --start-from-checkpoint $PRETRAINED_NLG_LM \
			          --config-override load_from_pretrained True random_seed $RANDOM_SEED learning_rate $LR batch_size $BATCH_SIZE checkpoint_every_step $EVAl_PER_STEPS num_training_steps $TRAIN_STEPS in_context_instance_count $IN_CONTEXT save_model_each_epoch False val_batch_size 32 --train --deepspeed
