# Language-Assisted Feature Transformation for Anomaly Detection

## Preparation

### Install PyTorch

```bash
conda install pytorch torchvision pytorch-cuda=12.1 -c pytorch -c nvidia
```

### Install dependencies

```bash
pip install -r requirements.txt
```

### Prepare datasets

- MNIST

  ```python
  # python
  from torchvision.datasets import MNIST
  MNIST(root="./data", download=True)
  ```

- Waterbirds

  ```python
  # python
  from wilds import get_dataset
  get_dataset("waterbirds", root="./data", version="1.0", download=True)
  ```

- CelebA

  ```python
  # python
  from torchvision.datasets import CelebA
  CelebA(root="./data", download=True)
  ```

  Please refer to [torchvision](https://pytorch.org/vision/stable/generated/torchvision.datasets.CelebA.html#torchvision.datasets.CelebA) documentation if you encounter any issues (e.g., download failure).

- MVTec AD

  `TODO`

### Reproduce results

See `runs/` for the configuration files and `scripts/` for the scripts to reproduce the results.
