DATASET_NAME = "industrial"
DATASET_CONFIG = {}

TEMPLATES = [
    "an image of a {}",
    "an image of the {}",
    "a photo of the {}.",
    "a photo of a {}.",
    "a bright photo of a {}.",
    "a bright photo of the {}.",
    "a dark photo of a {}.",
    "a dark photo of the {}.",
    "a jpeg corrupted photo of a {}.",
    "a jpeg corrupted photo of the {}.",
    "a blurry photo of the {}.",
    "a blurry photo of a {}.",
    "a photo of the {}.",
    "a photo of a {}.",
    "a photo of a {} for visual inspection.",
    "a photo of the {} for visual inspection.",
    "a photo of a {} for anomaly detection.",
    "a photo of the {} for anomaly detection.",
    "a detailed photo of a {}.",
    "a detailed photo of the {}.",
    "a zoomed-in photo of a {}.",
    "a zoomed-in photo of the {}.",
    "a side view of the {}.",
    "a top-down view of a {}.",
    "a high-resolution image of a {}.",
    "a high-resolution image of the {}.",
    "a close-up photo of a {}.",
    "a close-up photo of the {}.",
    "an inspection image of a {}.",
    "an inspection image of the {}.",
    "a grayscale photo of a {}.",
    "a grayscale photo of the {}.",
    "an overexposed photo of a {}.",
    "an overexposed photo of the {}.",
    "an underexposed photo of a {}.",
    "an underexposed photo of the {}.",
    "an artificially generated photo of a {}.",
    "an artificially generated photo of the {}.",
    "a distorted image of a {}.",
    "a distorted image of the {}.",
    "a noisy photo of a {}.",
    "a noisy photo of the {}.",
]
NORMAL_STATES = [
    "{}",
    "flawless {}",
    "perfect {}",
    "unblemished {}",
    "{} without flaw",
    "{} without defect",
    "{} without damage",
    "intact {}",
    "{} in perfect condition",
    "{} in excellent condition",
    "{} with no visible issues",
    "{} with no imperfections",
    "spotless {}",
    "clean and undamaged {}",
    "{} in optimal condition",
    "{} in ideal condition",
]
ANOMALY_STATES = [
    "damaged {}",
    "{} with flaw",
    "{} with defect",
    "{} with damage",
    "cracked {}",
    "scratched {}",
    "distorted {}",
    "{} with imperfections",
    "malformed {}",
    "{} with a tear",
    "faulty {}",
    "broken {}",
    "{} with visible damage",
    "{} with discoloration",
    "{} showing irregularities",
    "fractured {}",
    "{} with a scratch",
]
NORMAL_TEMPLATES = [f.format(s) for f in TEMPLATES for s in NORMAL_STATES]
ANOMALY_TEMPLATES = [f.format(s) for f in TEMPLATES for s in ANOMALY_STATES]


def get_prompts(category: str):
    normal_prompts = [f.format(category) for f in NORMAL_TEMPLATES]
    anomaly_prompts = [f.format(category) for f in ANOMALY_TEMPLATES]
    return normal_prompts, anomaly_prompts
