import os

import torch
import torch.nn as nn
import numpy as np
import math 
import glob
import re
from shutil import copyfile

def makedirs(dirname):
	if not os.path.exists(dirname):
		os.makedirs(dirname)

def create_net(n_inputs, n_outputs, n_layers = 1, 
	n_units = 100, nonlinear = nn.Tanh):
	if n_layers == 0:
		layers = [nn.Linear(n_inputs, n_outputs)]
	else:
		layers = [nn.Linear(n_inputs, n_units)]
		for i in range(n_layers-1):
			layers.append(nonlinear())
			layers.append(nn.Linear(n_units, n_units))
		layers.append(nonlinear())
		layers.append(nn.Linear(n_units, n_outputs))
	return nn.Sequential(*layers)


def create_net_reg(n_inputs, n_outputs, n_layers = 1, 
	n_units = 100, nonlinear = nn.Tanh, drop_rate = 0.0):
	if n_layers == 0:
		layers = [nn.Linear(n_inputs, n_outputs)]
	else:
		layers = [nn.Linear(n_inputs, n_units)]
		layers.append(nn.Dropout(p=drop_rate))
		layers.append(nn.LayerNorm(n_units))
		for i in range(n_layers-1):
			layers.append(nonlinear())
			layers.append(nn.utils.weight_norm(nn.Linear(n_units, n_units)))
			layers.append(nn.Dropout(p=drop_rate))
			layers.append(nn.LayerNorm(n_units))
		layers.append(nonlinear())
		layers.append(nn.utils.weight_norm(nn.Linear(n_units, n_outputs)))
		layers.append(nn.Dropout(p=drop_rate))
	return nn.Sequential(*layers)


