from gym.envs.registration import register
from .envs import *

register(
    id='sepsis-expertpo-v0',
    entry_point='sepsis_env.envs:SepsisSimulatedEnv',
    max_episode_steps=20,
)

register(
    id='sepsis-expertfo-v0',
    entry_point='sepsis_env.envs:SepsisSimulatedEnv',
    max_episode_steps=20,
    kwargs={"observe_diabetes": True}
)

register(
    id='sepsis-smallexpertpo-v0',
    entry_point='sepsis_env.envs:SepsisSimulatedEnv',
    max_episode_steps=20,
    kwargs={"dataset": "eps_0_1-10k"}
)

register(
    id='sepsis-smallexpertfo-v0',
    entry_point='sepsis_env.envs:SepsisSimulatedEnv',
    max_episode_steps=20,
    kwargs={"dataset": "eps_0_1-10k", "observe_diabetes": True}
)

for gamma in [1, 15, 30, 46, 66]:
    register(
        id=f'sepsis-gamma{gamma}-v0',
        entry_point='sepsis_env.envs:SepsisSimulatedEnv',
        max_episode_steps=20,
        kwargs={"dataset": f"Gamma{gamma}_eps_0_1-100k"}
    )
