import torch
from PIL import Image
from lavis.models import load_model_and_preprocess
import torch
from copy import deepcopy
import os
from tqdm import tqdm

device = torch.device("cuda:7")
model, vis_processors, _ = load_model_and_preprocess(name="texpel_caption", model_type="base_coco", is_eval=True, device=device)

directory = '/PATH/landbirds'
caption_path = './PATH/.txt'

# iterate over files
for filename in tqdm(os.listdir(directory)):
    f = os.path.join(directory, filename)
    if os.path.isfile(f):
        image = Image.open(f).convert('RGB')
        image = vis_processors["eval"](image).unsqueeze(0).to(device)
        # counts, captions = model.generate({"image": image})
        captions = model.generate({"image": image})

        if os.path.exists(caption_path):
            file = open(caption_path, 'a')
            for sentence in captions:
                file.write(sentence + "\n")
            file.close()
        else:
            file = open(caption_path, 'w')
            for sentence in captions:
                file.write(sentence + "\n")
            file.close()

