# Contributing to HippoRAG

Thank you for your interest in contributing to HippoRAG!
We are happy to welcome contributions from the community to help us improve our project.

## How to Contribute

1. Fork the repository and clone it to your local machine.
2. Create a new branch for your contribution: `git checkout -b my-contribution`.
3. Make your changes and ensure that the code passes our test scripts. More information can be found in the `Testing` section of our `README.md`. 
4. Commit your changes: `git commit -m "Add my contribution"`.
6. Push your changes to your forked repository: `git push origin my-contribution`.
7. Open a pull request to the main repository.

## Before you start, file an issue

Please follow this simple rule to help us eliminate any unnecessary wasted effort & frustration, and ensure an efficient and effective use of everyone's time - yours, ours, and other community members':

> 👉 If you have a question, think you've discovered an issue, would like to propose a new feature, etc., then find/file an issue **BEFORE** starting work to fix/implement it.

### Search existing issues first

Before filing a new issue, search existing open and closed issues first: This project is moving fast! It is likely someone else has found the problem you're seeing, and someone may be working on or have already contributed a fix!

If no existing item describes your issue/feature, great - please file a new issue:

### File a new Issue

- Don't know whether you're reporting an issue or requesting a feature? File an issue
- Have a question that you don't see answered in docs, videos, etc.? File an issue
- Want to know if we're planning on building a particular feature? File an issue
- Got a great idea for a new feature? File an issue/request/idea
- Don't understand how to do something? File an issue
- Found an existing issue that describes yours? Great - upvote and add additional commentary / info / repro-steps / etc.
 
Provide as much detail as possible to help us understand and address the problem.

---

### Credits

This contributing guide was adapted from the [GraphRAG](https://github.com/microsoft/graphrag) project. Many thanks to the team for providing a useful starting point!

---

## Thank you

We appreciate your contributions to HippoRAG!

