#!/bin/bash


dist=UU
epochs=1000


function test () {
  train_options=$1
  echo python3 print_exp_dir.py ${train_options}
  
  model_path=`python3 print_exp_dir.py ${train_options}`
  
  echo ${model_path}
  for test_N in 3 5 7 9; do
    test_dat="./datasets/test/${dist}_size-$(printf "%02d" ${test_N})_test.dat"
    echo python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}
    
    python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}

  done
}

# test the models that accepts variable-size input.

## WeaveNet_A-6
train_options="--network_type WeaveNet_A -L 6 -w 64 -W 28 -N 10 10 -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --use_resnet"
echo python3 train.py ${train_options}

#python3 train.py ${train_options}

#test "${train_options}"

## DBM_A-6
train_options="--network_type DBM_A -L 6 -w 48 -W 32 -N 10 10 -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --use_resnet"
#echo python3 train.py ${train_options}

#python3 train.py ${train_options}

#test "${train_options}"

# test the non-flexible models
for N in 3 5 7 9; do

  # MLP-O
  train_options="--network_type MLP --constraint_p -1 -L 3 -w 100 -N ${N} ${N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --device -2"
  echo python3 train.py ${train_options}
  
  python3 train.py ${train_options}
  model_path=`python3 print_exp_dir.py ${train_options}`
  
  echo ${model_path}
  test_dat="./datasets/test/${dist}_size-$(printf "%02d" ${N})_test.dat"
  echo python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}
  
  python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat} 
  
  
  
  # GIN
  train_options="--network_type GIN -lr 0.0001 -L 3 -w 44 -N ${N} ${N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --device -2"
  echo python3 train.py ${train_options}
  
  python3 train.py ${train_options}
  model_path=`python3 print_exp_dir.py ${train_options}`
  
  echo ${model_path}
  test_dat="./datasets/test/${dist}_size-$(printf "%02d" ${N})_test.dat"
  echo python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}
  
  python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat} 
done

