#!/bin/bash

opt=$1

trainer=M3PL
CFG=vit_b16_p8_c2+2_d3+3_ep50_batch512

N_PROMPTS=8
shots=16
LAMBDA=1.0

if [ ${trainer} = 'M3PL' ]
then
    if [ ${opt} = "base2new" ]
    then
        python parse_test_res.py output/base2new/train_base/imagenet/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/imagenet/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/caltech101/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/caltech101/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/oxford_pets/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/oxford_pets/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/stanford_cars/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/stanford_cars/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/oxford_flowers/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/oxford_flowers/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/food101/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/food101/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/fgvc_aircraft/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/fgvc_aircraft/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/sun397/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/sun397/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/dtd/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/dtd/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/eurosat/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/eurosat/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/train_base/ucf101/shots_${shots}/${trainer}/${CFG}/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/base2new/test_new/ucf101/shots_${shots}/${trainer}/${CFG}/ --test-log --multi --n_prompts ${N_PROMPTS}
    elif [ ${opt} = "cross" ]
    then
        python parse_test_res.py output/imagenet/${trainer}/${CFG}_${shots}shots/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/caltech101/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/oxford_pets/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/stanford_cars/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/oxford_flowers/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/food101/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/fgvc_aircraft/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/sun397/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/dtd/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/eurosat/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/ucf101/ --test-log --multi --n_prompts ${N_PROMPTS}
    else
        python parse_test_res.py output/imagenet/${trainer}/${CFG}_${shots}shots/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenetv2/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenet_sketch/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenet_a/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenet_r/ --test-log --multi --n_prompts ${N_PROMPTS}
    fi
else
    if [ ${opt} = "base2new" ]
    then
        python parse_test_res.py output/base2new/train_base/imagenet/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/imagenet/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/caltech101/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/caltech101/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/oxford_pets/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/oxford_pets/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/stanford_cars/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/stanford_cars/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/oxford_flowers/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/oxford_flowers/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/food101/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/food101/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/fgvc_aircraft/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/fgvc_aircraft/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/sun397/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/sun397/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/dtd/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/dtd/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/eurosat/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/eurosat/shots_${shots}/${trainer}/${CFG}/ --test-log
        python parse_test_res.py output/base2new/train_base/ucf101/shots_${shots}/${trainer}/${CFG}/
        python parse_test_res.py output/base2new/test_new/ucf101/shots_${shots}/${trainer}/${CFG}/ --test-log
    elif [ ${opt} = "cross" ]
    then
        python parse_test_res.py output/imagenet/${trainer}/${CFG}_${shots}shots/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/caltech101/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/oxford_pets/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/stanford_cars/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/oxford_flowers/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/food101/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/fgvc_aircraft/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/sun397/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/dtd/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/eurosat/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/ucf101/ --test-log --multi --n_prompts ${N_PROMPTS}
    else
        python parse_test_res.py output/imagenet/${trainer}/${CFG}_${shots}shots/ --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenetv2/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenet_sketch/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenet_a/ --test-log --multi --n_prompts ${N_PROMPTS}
        python parse_test_res.py output/evaluation/${trainer}/${CFG}_${shots}shots/imagenet_r/ --test-log --multi --n_prompts ${N_PROMPTS}
    fi
fi

