import os
import random
import numpy as np
import torch

# Reference: https://pytorch.org/docs/stable/notes/randomness
def set_seed(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.benchmark = False
    torch.backends.cudnn.deterministic = True
    torch.use_deterministic_algorithms(True)
    # Reference: https://stackoverflow.com/questions/66682127/problem-with-determinism-set-a-buffer-size-in-the-cublas-workspace-config-envi
    os.environ["CUBLAS_WORKSPACE_CONFIG"]=":16:8" # :4096:8
